/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.definitions.AEItems;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.OutputSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.inv.AppEngInternalInventory;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.api.IPage;
import com.glodblock.github.extendedae.client.ExSemantics;
import com.glodblock.github.extendedae.client.gui.widget.SingleFakeSlot;
import com.glodblock.github.extendedae.common.me.itemhost.HostPatternModifier;
import com.glodblock.github.extendedae.util.Ae2Reflect;
import com.glodblock.github.glodium.network.packet.sync.ActionMap;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import java.util.Arrays;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerPatternModifier
extends AEBaseMenu
implements IPage,
IActionHolder {
    private final ActionMap actions = ActionMap.create();
    public static final MenuType<ContainerPatternModifier> TYPE = MenuTypeBuilder.create(ContainerPatternModifier::new, HostPatternModifier.class).buildUnregistered(ExtendedAE.id("pattern_modifier"));
    public final AppEngSlot targetSlot;
    public final AppEngSlot cloneSlot;
    public final AppEngSlot replaceTarget;
    public final AppEngSlot replaceWith;
    @GuiSync(value=1)
    public int page;

    public ContainerPatternModifier(int id, Inventory playerInventory, HostPatternModifier host) {
        super(TYPE, id, playerInventory, (Object)host);
        this.createPlayerInventorySlots(playerInventory);
        AppEngInternalInventory patternInv = host.getInventoryByName("patternInv");
        for (int x = 0; x < patternInv.size(); ++x) {
            this.addSlot((Slot)new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.PROVIDER_PATTERN, (InternalInventory)patternInv, x), SlotSemantics.ENCODED_PATTERN);
        }
        AppEngInternalInventory targetInv = host.getInventoryByName("targetInv");
        AppEngInternalInventory blankPatternInv = host.getInventoryByName("blankPatternInv");
        AppEngInternalInventory clonePatternInv = host.getInventoryByName("clonePatternInv");
        AppEngInternalInventory replaceInv = host.getInventoryByName("replaceInv");
        this.targetSlot = (AppEngSlot)this.addSlot((Slot)new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.PROVIDER_PATTERN, (InternalInventory)targetInv, 0), ExSemantics.EX_1);
        this.cloneSlot = (AppEngSlot)this.addSlot((Slot)new OutputSlot((InternalInventory)clonePatternInv, 0, null), ExSemantics.EX_2);
        this.replaceTarget = (AppEngSlot)this.addSlot((Slot)new SingleFakeSlot((InternalInventory)replaceInv, 0), ExSemantics.EX_4);
        this.replaceWith = (AppEngSlot)this.addSlot((Slot)new SingleFakeSlot((InternalInventory)replaceInv, 1), ExSemantics.EX_5);
        for (int x = 0; x < blankPatternInv.size(); ++x) {
            this.addSlot((Slot)new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.BLANK_PATTERN, (InternalInventory)blankPatternInv, x), ExSemantics.EX_3);
        }
        this.actions.put("clear", o -> this.clear());
        this.actions.put("clone", o -> this.clonePattern());
        this.actions.put("modify", o -> this.modify((Integer)o.get(0), (Boolean)o.get(1)));
        this.actions.put("replace", o -> this.replace());
        this.actions.put("pattern_mode", o -> this.changePatternMode((Integer)o.get(0), (Boolean)o.get(1)));
        this.actions.put("show", o -> this.showPage());
    }

    public void showPage() {
        AppEngSlot as;
        for (Slot slot : this.getSlots(SlotSemantics.ENCODED_PATTERN)) {
            if (!(slot instanceof AppEngSlot)) continue;
            as = (AppEngSlot)slot;
            as.setSlotEnabled(this.page == 0 || this.page == 1 || this.page == 2);
        }
        this.replaceTarget.setSlotEnabled(this.page == 1);
        this.replaceWith.setSlotEnabled(this.page == 1);
        this.targetSlot.setSlotEnabled(this.page == 3);
        this.cloneSlot.setSlotEnabled(this.page == 3);
        for (Slot slot : this.getSlots(ExSemantics.EX_3)) {
            if (!(slot instanceof AppEngSlot)) continue;
            as = (AppEngSlot)slot;
            as.setSlotEnabled(this.page == 3);
        }
    }

    public void replace() {
        ItemStack replace = this.replaceTarget.getItem();
        ItemStack with = this.replaceWith.getItem();
        if (replace.isEmpty()) {
            return;
        }
        for (Slot slot : this.getSlots(SlotSemantics.ENCODED_PATTERN)) {
            GenericStack[] replaceInput;
            GenericStack[] output;
            GenericStack[] input;
            ItemStack stack = slot.getItem();
            IPatternDetails detail = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)this.getPlayer().level());
            if (detail instanceof AEProcessingPattern) {
                AEProcessingPattern process = (AEProcessingPattern)detail;
                input = process.getSparseInputs().toArray(new GenericStack[0]);
                output = process.getOutputs().toArray(new GenericStack[0]);
                replaceInput = new GenericStack[input.length];
                GenericStack[] replaceOutput = new GenericStack[output.length];
                this.replace(input, replaceInput, (AEKey)AEItemKey.of((ItemStack)replace), (AEKey)AEItemKey.of((ItemStack)with));
                this.replace(output, replaceOutput, (AEKey)AEItemKey.of((ItemStack)replace), (AEKey)AEItemKey.of((ItemStack)with));
                ItemStack newPattern = PatternDetailsHelper.encodeProcessingPattern(Arrays.stream(replaceInput).toList(), Arrays.stream(replaceOutput).toList());
                slot.set(newPattern);
                continue;
            }
            if (!(detail instanceof AECraftingPattern)) continue;
            AECraftingPattern craft = (AECraftingPattern)detail;
            input = craft.getSparseInputs().toArray(new GenericStack[0]);
            output = craft.getPrimaryOutput();
            replaceInput = new GenericStack[input.length];
            this.replace(input, replaceInput, (AEKey)AEItemKey.of((ItemStack)replace), (AEKey)AEItemKey.of((ItemStack)with));
            try {
                ItemStack newPattern = PatternDetailsHelper.encodeCraftingPattern(Ae2Reflect.getCraftRecipe(craft), (ItemStack[])this.itemize(replaceInput), (ItemStack)this.itemize((GenericStack)output), (boolean)craft.canSubstitute, (boolean)craft.canSubstituteFluids);
                AECraftingPattern check = new AECraftingPattern(AEItemKey.of((ItemStack)newPattern), this.getPlayer().level());
                if (check == null) continue;
                slot.set(newPattern);
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public void clear() {
        for (Slot slot : this.getSlots(SlotSemantics.ENCODED_PATTERN)) {
            ItemStack stack = slot.getItem();
            if (!(stack.getItem() instanceof EncodedPatternItem)) continue;
            slot.set(AEItems.BLANK_PATTERN.stack());
        }
    }

    public void clonePattern() {
        IPatternDetails detail;
        ItemStack target = this.targetSlot.getItem();
        ItemStack clone = this.cloneSlot.getItem();
        if (target.getItem() instanceof EncodedPatternItem && (detail = PatternDetailsHelper.decodePattern((ItemStack)target, (Level)this.getPlayer().level())) != null) {
            ItemStack newPattern = target.copy();
            if (clone.isEmpty()) {
                if (this.consumeBlankPattern()) {
                    this.cloneSlot.set(newPattern);
                }
            } else if (clone.getItem() instanceof EncodedPatternItem) {
                this.cloneSlot.set(newPattern);
            }
        }
    }

    public void modify(int scale, boolean div) {
        if (scale <= 0) {
            return;
        }
        for (Slot slot : this.getSlots(SlotSemantics.ENCODED_PATTERN)) {
            ItemStack stack = slot.getItem();
            IPatternDetails detail = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)this.getPlayer().level());
            if (!(detail instanceof AEProcessingPattern)) continue;
            AEProcessingPattern process = (AEProcessingPattern)detail;
            GenericStack[] input = process.getSparseInputs().toArray(new GenericStack[0]);
            GenericStack[] output = process.getOutputs().toArray(new GenericStack[0]);
            if (!this.checkModify(input, scale, div) || !this.checkModify(output, scale, div)) continue;
            GenericStack[] mulInput = new GenericStack[input.length];
            GenericStack[] mulOutput = new GenericStack[output.length];
            this.modifyStacks(input, mulInput, scale, div);
            this.modifyStacks(output, mulOutput, scale, div);
            ItemStack newPattern = PatternDetailsHelper.encodeProcessingPattern(Arrays.stream(mulInput).toList(), Arrays.stream(mulOutput).toList());
            slot.set(newPattern);
        }
    }

    private boolean checkModify(GenericStack[] stacks, int scale, boolean div) {
        if (div) {
            for (GenericStack stack : stacks) {
                if (stack == null || stack.amount() % (long)scale == 0L) continue;
                return false;
            }
        } else {
            for (GenericStack stack : stacks) {
                if (stack == null) continue;
                long upper = 999999L * (long)stack.what().getAmountPerUnit();
                if (stack.amount() * (long)scale <= upper) continue;
                return false;
            }
        }
        return true;
    }

    private void modifyStacks(GenericStack[] stacks, GenericStack[] des, int scale, boolean div) {
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            long amt = div ? stacks[i].amount() / (long)scale : stacks[i].amount() * (long)scale;
            des[i] = new GenericStack(stacks[i].what(), amt);
        }
    }

    private void replace(GenericStack[] stacks, GenericStack[] des, AEKey replace, @Nullable AEKey with) {
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            if (stacks[i].what().equals(replace)) {
                if (with == null) {
                    des[i] = null;
                    continue;
                }
                des[i] = new GenericStack(with, stacks[i].amount());
                continue;
            }
            des[i] = new GenericStack(stacks[i].what(), stacks[i].amount());
        }
    }

    private ItemStack[] itemize(GenericStack[] stacks) {
        ItemStack[] items = new ItemStack[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            items[i] = this.itemize(stacks[i]);
        }
        return items;
    }

    private ItemStack itemize(GenericStack stack) {
        AEKey aEKey;
        if (stack != null && (aEKey = stack.what()) instanceof AEItemKey) {
            AEItemKey what = (AEItemKey)aEKey;
            return what.toStack((int)stack.amount());
        }
        return ItemStack.EMPTY;
    }

    private boolean consumeBlankPattern() {
        for (Slot slot : this.getSlots(ExSemantics.EX_3)) {
            ItemStack stack = slot.getItem();
            if (stack.isEmpty() || !AEItems.BLANK_PATTERN.is(stack)) continue;
            stack.shrink(1);
            if (stack.getCount() <= 0) {
                slot.set(ItemStack.EMPTY);
            }
            return true;
        }
        return false;
    }

    private void changePatternMode(int mode, boolean value) {
        for (Slot slot : this.getSlots(SlotSemantics.ENCODED_PATTERN)) {
            ItemStack stack = slot.getItem();
            IPatternDetails detail = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)this.getPlayer().level());
            if (!(detail instanceof AECraftingPattern)) continue;
            AECraftingPattern craft = (AECraftingPattern)detail;
            GenericStack[] input = craft.getSparseInputs().toArray(new GenericStack[0]);
            GenericStack output = craft.getPrimaryOutput();
            ItemStack newPattern = PatternDetailsHelper.encodeCraftingPattern(Ae2Reflect.getCraftRecipe(craft), (ItemStack[])this.itemize(input), (ItemStack)this.itemize(output), (boolean)(mode == 0 ? value : craft.canSubstitute), (boolean)(mode == 1 ? value : craft.canSubstituteFluids));
            slot.set(newPattern);
        }
    }

    @Override
    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @NotNull
    public ActionMap getActionMap() {
        return this.actions;
    }
}

