/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.trunks;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.orcinus.galosphere.init.GTrunkPlacers;

public class OpalTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<OpalTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)0, (int)32).fieldOf("base_height").forGetter(trunkPlacer -> trunkPlacer.baseHeight), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_a").forGetter(trunkPlacer -> trunkPlacer.heightRandA), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_b").forGetter(trunkPlacer -> trunkPlacer.heightRandB), (App)IntProvider.codec((int)0, (int)4).fieldOf("branch_length").forGetter(trunkPlacer -> trunkPlacer.branchLength)).apply((Applicative)instance, OpalTrunkPlacer::new));
    private final IntProvider branchLength;

    public OpalTrunkPlacer(int i, int j, int k, IntProvider branchLength) {
        super(i, j, k);
        this.branchLength = branchLength;
    }

    protected TrunkPlacerType<?> type() {
        return GTrunkPlacers.OPAL_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader levelSimulatedReader, BiConsumer<BlockPos, BlockState> biConsumer, RandomSource randomSource, int height, BlockPos blockPos, TreeConfiguration treeConfiguration) {
        ArrayList foliageAttachments = Lists.newArrayList();
        int branchLength = this.branchLength.sample(randomSource);
        for (Direction branchingDirection : Direction.Plane.HORIZONTAL) {
            if (!(randomSource.nextFloat() < 0.6f)) continue;
            int maxLength = UniformInt.of((int)1, (int)2).sample(randomSource);
            for (int length = 0; length <= maxLength; ++length) {
                this.placeLog(levelSimulatedReader, biConsumer, randomSource, blockPos.relative(branchingDirection).above(length), treeConfiguration);
            }
        }
        for (int i = 0; i <= height; ++i) {
            BlockPos logPos = blockPos.above(i);
            if (i == height - 2) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    for (int length = 0; length <= branchLength; ++length) {
                        BlockPos branchPos = logPos.relative(direction, length);
                        Function<BlockState, BlockState> function = blockState -> (BlockState)blockState.trySetValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis());
                        this.placeLog(levelSimulatedReader, biConsumer, randomSource, branchPos, treeConfiguration, function);
                        if (length != branchLength) continue;
                        this.placeLog(levelSimulatedReader, biConsumer, randomSource, branchPos.above(), treeConfiguration);
                    }
                }
            }
            if (i == height) {
                int secondBranchLength = branchLength * 2;
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    for (int length = 0; length <= secondBranchLength; ++length) {
                        BlockPos branchPos = logPos.relative(direction, length);
                        Function<BlockState, BlockState> function = blockState -> (BlockState)blockState.trySetValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis());
                        this.placeLog(levelSimulatedReader, biConsumer, randomSource, branchPos, treeConfiguration, function);
                        if (length != secondBranchLength) continue;
                        foliageAttachments.add(new FoliagePlacer.FoliageAttachment(branchPos.above(), 0, false));
                        this.placeLog(levelSimulatedReader, biConsumer, randomSource, branchPos.above(), treeConfiguration);
                    }
                }
            }
            this.placeLog(levelSimulatedReader, biConsumer, randomSource, logPos, treeConfiguration);
            if (i != height) continue;
            foliageAttachments.add(new FoliagePlacer.FoliageAttachment(logPos.above(), 0, false));
        }
        return foliageAttachments;
    }
}

