/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.processors.ancient_cities;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GStructureProcessorTypes;
import org.jetbrains.annotations.Nullable;

public class EchoAltarProcessor
extends StructureProcessor {
    public static final MapCodec<EchoAltarProcessor> CODEC = MapCodec.unit(EchoAltarProcessor::new);

    @Nullable
    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos blockPos, BlockPos blockPos2, StructureTemplate.StructureBlockInfo structureBlockInfo, StructureTemplate.StructureBlockInfo structureBlockInfo2, StructurePlaceSettings structurePlaceSettings) {
        BlockState state = structureBlockInfo2.state();
        BlockPos above = structureBlockInfo2.pos().above();
        if (state.is(Blocks.GRAY_CARPET)) {
            for (Direction direction : Direction.values()) {
                int count;
                BlockPos pos = structureBlockInfo2.pos().relative(direction, 2);
                BlockState stairState = levelReader.getChunk(pos).getBlockState(pos);
                if (!stairState.is(Blocks.DEEPSLATE_TILE_STAIRS) || (count = EchoAltarProcessor.calculateStairCount(levelReader, above)) != 2) continue;
                BlockPos altarPos = above.below().relative(((Direction)stairState.getValue((Property)StairBlock.FACING)).getOpposite());
                levelReader.getChunk(altarPos).setBlockState(altarPos, ((Block)GBlocks.ECHO_ALTAR.get()).defaultBlockState(), false);
            }
        }
        return structureBlockInfo2;
    }

    private static int calculateStairCount(LevelReader levelReader, BlockPos above) {
        Direction dir;
        int count = 0;
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        for (int i = 0; !(i >= n || levelReader.getChunk(above.relative(dir = directionArray[i])).getBlockState(above.relative(dir)).is(Blocks.DEEPSLATE_BRICK_WALL) && ++count == 2); ++i) {
        }
        return count;
    }

    protected StructureProcessorType<?> getType() {
        return GStructureProcessorTypes.ECHO_ALTAR.get();
    }
}

