/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.features;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.neoforged.neoforge.common.Tags;
import net.orcinus.galosphere.blocks.PalladiumDustBlock;
import net.orcinus.galosphere.world.gen.features.config.PalladiumDustConfiguration;

public class PalladiumDustFeature
extends Feature<PalladiumDustConfiguration> {
    public PalladiumDustFeature(Codec<PalladiumDustConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<PalladiumDustConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.level();
        BlockPos blockPos = featurePlaceContext.origin();
        RandomSource random = featurePlaceContext.random();
        PalladiumDustConfiguration config = (PalladiumDustConfiguration)featurePlaceContext.config();
        BlockPos.MutableBlockPos mutable = blockPos.mutable();
        int tries = 60;
        Direction movingDirection = null;
        for (int i = 0; i < tries; ++i) {
            block6: {
                block5: {
                    if (movingDirection == null || random.nextInt(5) != 0) break block5;
                    Direction direction = movingDirection = movingDirection.getAxis() == Direction.Axis.Y ? movingDirection.getOpposite() : movingDirection.getClockWise();
                    if (!world.getBlockState(mutable.relative(movingDirection)).isAir()) break block6;
                    movingDirection = null;
                    break block6;
                }
                List randomDirections = Util.shuffledCopy((Object[])Direction.values(), (RandomSource)random);
                for (Direction direction : randomDirections) {
                    if (world.getBlockState(mutable.relative(direction)).isAir()) continue;
                    movingDirection = direction;
                    break;
                }
            }
            if (movingDirection == null) continue;
            if (Math.sqrt(blockPos.distSqr((Vec3i)mutable)) > 4.0) break;
            BlockState state = world.getBlockState((BlockPos)mutable);
            BlockState blockState = config.placeBlock().getState(random, (BlockPos)mutable).getBlock().defaultBlockState();
            if (state.is(Tags.Blocks.ORES) || state.is(BlockTags.BASE_STONE_OVERWORLD)) {
                for (Direction direction : Direction.values()) {
                    BlockPos relativeMut = mutable.relative(direction);
                    BlockState relativeState = world.getBlockState(relativeMut);
                    if (!world.getFluidState(relativeMut).isEmpty() || !relativeState.canBeReplaced() || relativeState.getBlock() instanceof DoublePlantBlock) continue;
                    for (Direction dir : Direction.values()) {
                        BlockState immuteState = world.getBlockState(relativeMut.immutable().relative(dir));
                        boolean hasFace = world.getFluidState(relativeMut.immutable().relative(dir)).isEmpty() && PalladiumDustBlock.canAttachTo((BlockGetter)world, (Direction)dir, (BlockPos)relativeMut.immutable().relative(dir), (BlockState)immuteState);
                        blockState = (BlockState)blockState.setValue((Property)PalladiumDustBlock.getFaceProperty((Direction)dir), (Comparable)Boolean.valueOf(hasFace));
                    }
                    world.setBlock(relativeMut, blockState, 2);
                }
            }
            mutable.move(movingDirection);
        }
        return true;
    }
}

