/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.features;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class LichenPatchFeature
extends Feature<VegetationPatchConfiguration> {
    public LichenPatchFeature(Codec<VegetationPatchConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<VegetationPatchConfiguration> context) {
        WorldGenLevel worldgenlevel = context.level();
        VegetationPatchConfiguration vegetationpatchconfiguration = (VegetationPatchConfiguration)context.config();
        RandomSource randomsource = context.random();
        BlockPos blockpos = context.origin();
        Predicate<BlockState> predicate = state -> state.is(vegetationpatchconfiguration.replaceable);
        int i = vegetationpatchconfiguration.xzRadius.sample(randomsource) + 1;
        int j = vegetationpatchconfiguration.xzRadius.sample(randomsource) + 1;
        Set<BlockPos> set = this.placeGroundPatch(worldgenlevel, vegetationpatchconfiguration, randomsource, blockpos, predicate, i, j);
        this.distributeVegetation(context, worldgenlevel, vegetationpatchconfiguration, randomsource, set);
        return !set.isEmpty();
    }

    protected Set<BlockPos> placeGroundPatch(WorldGenLevel world, VegetationPatchConfiguration config, RandomSource random, BlockPos blockPos, Predicate<BlockState> predicate, int xRadius, int zRadius) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = blockPos.mutable();
        BlockPos.MutableBlockPos blockpos$mutableblockpos1 = blockpos$mutableblockpos.mutable();
        Direction direction = config.surface.getDirection();
        Direction direction1 = direction.getOpposite();
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (int i = -xRadius; i <= xRadius; ++i) {
            boolean flag = i == -xRadius || i == xRadius;
            for (int j = -zRadius; j <= zRadius; ++j) {
                boolean flag4;
                boolean flag1 = j == -zRadius || j == zRadius;
                boolean flag2 = flag || flag1;
                boolean flag3 = flag && flag1;
                boolean bl = flag4 = flag2 && !flag3;
                if (flag3 || flag4 && (config.extraEdgeColumnChance == 0.0f || random.nextFloat() > config.extraEdgeColumnChance)) continue;
                blockpos$mutableblockpos.setWithOffset((Vec3i)blockPos, i, 0, j);
                for (int k = 0; world.isStateAtPosition((BlockPos)blockpos$mutableblockpos, DripstoneUtils::isEmptyOrWater) && k < config.verticalRange; ++k) {
                    blockpos$mutableblockpos.move(direction);
                }
                for (int i1 = 0; world.isStateAtPosition((BlockPos)blockpos$mutableblockpos, state -> !state.isAir() && !state.is(Blocks.WATER)) && i1 < config.verticalRange; ++i1) {
                    blockpos$mutableblockpos.move(direction1);
                }
                blockpos$mutableblockpos1.setWithOffset((Vec3i)blockpos$mutableblockpos, config.surface.getDirection());
                BlockState blockstate = world.getBlockState((BlockPos)blockpos$mutableblockpos1);
                if (!world.isStateAtPosition((BlockPos)blockpos$mutableblockpos, DripstoneUtils::isEmptyOrWater) || !blockstate.isFaceSturdy((BlockGetter)world, (BlockPos)blockpos$mutableblockpos1, config.surface.getDirection().getOpposite())) continue;
                int l = config.depth.sample(random) + (config.extraBottomBlockChance > 0.0f && random.nextFloat() < config.extraBottomBlockChance ? 1 : 0);
                BlockPos blockpos = blockpos$mutableblockpos1.immutable();
                boolean flag5 = this.placeGround(world, config, predicate, random, blockpos$mutableblockpos1, l);
                if (!flag5) continue;
                set.add(blockpos);
            }
        }
        return set;
    }

    protected void distributeVegetation(FeaturePlaceContext<VegetationPatchConfiguration> context, WorldGenLevel world, VegetationPatchConfiguration config, RandomSource random, Set<BlockPos> set) {
        for (BlockPos blockpos : set) {
            if (!(config.vegetationChance > 0.0f) || !(random.nextFloat() > 0.85f)) continue;
            this.placeVegetation(world, config, context.chunkGenerator(), random, blockpos);
        }
    }

    protected boolean placeVegetation(WorldGenLevel world, VegetationPatchConfiguration config, ChunkGenerator chunkGenerator, RandomSource random, BlockPos pos) {
        return ((PlacedFeature)config.vegetationFeature.value()).place(world, chunkGenerator, random, pos.relative(config.surface.getDirection().getOpposite()));
    }

    protected boolean placeGround(WorldGenLevel world, VegetationPatchConfiguration config, Predicate<BlockState> predicate, RandomSource random, BlockPos.MutableBlockPos mutable, int tries) {
        for (int i = 0; i < tries; ++i) {
            BlockState blockstate1;
            BlockState blockstate = config.groundState.getState(random, (BlockPos)mutable);
            if (blockstate.is((blockstate1 = world.getBlockState((BlockPos)mutable)).getBlock())) continue;
            if (!predicate.test(blockstate1)) {
                return i != 0;
            }
            world.setBlock((BlockPos)mutable, blockstate, 2);
            mutable.move(config.surface.getDirection());
        }
        return true;
    }
}

