/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.orcinus.galosphere.init.GBlocks;

public class LichenColumnFeature
extends Feature<NoneFeatureConfiguration> {
    public LichenColumnFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.level();
        BlockPos blockPos = featurePlaceContext.origin();
        RandomSource random = featurePlaceContext.random();
        if (world.getBlockState(blockPos).isAir()) {
            world.setBlock(blockPos, ((Block)GBlocks.LICHEN_MOSS.get()).defaultBlockState(), 2);
            int length = UniformInt.of((int)2, (int)7).sample(random);
            if (random.nextFloat() < 0.45f) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    length = UniformInt.of((int)1, (int)7).sample(random);
                    if (!random.nextBoolean() || !world.getBlockState(blockPos.relative(direction)).isAir()) continue;
                    LichenColumnFeature.placeColumn(blockPos.relative(direction), world, (BlockState)((Block)GBlocks.LICHEN_VINES.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction), length);
                }
            } else {
                LichenColumnFeature.placeColumn(blockPos, world, ((Block)GBlocks.LICHEN_MOSS.get()).defaultBlockState(), length);
            }
            return true;
        }
        return false;
    }

    private static void placeColumn(BlockPos blockPos, WorldGenLevel world, BlockState randomState, int length) {
        BlockPos placePos;
        for (int i = 0; i < length && world.isStateAtPosition(placePos = blockPos.below(i), DripstoneUtils::isEmptyOrWater); ++i) {
            world.setBlock(placePos, randomState, 2);
        }
    }
}

