/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.util;

import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;

public class CompatUtil {
    public boolean isModInstalled(String modid) {
        return ModList.get().isLoaded(modid);
    }

    public boolean matchesCompatBlock(Block block, String modid, String name) {
        return block == this.getCompatBlock(modid, name);
    }

    public boolean matchesCompatItem(Item item, String modid, String name) {
        return item == this.getCompatItem(modid, name);
    }

    public boolean matchesCompatParticle(SimpleParticleType particleType, String modid, String name) {
        return particleType == this.getCompatParticle(modid, name);
    }

    public boolean matchesCompatEffect(MobEffect effect, String modid, String name) {
        return effect == this.getCompatEffect(modid, name);
    }

    public Block getCompatBlock(String modid, String name) {
        return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    public Item getCompatItem(String modid, String name) {
        return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    public SimpleParticleType getCompatParticle(String modid, String name) {
        return (SimpleParticleType)BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    public MobEffect getCompatEffect(String modid, String name) {
        return (MobEffect)BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }
}

