/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.init.GItems;

public class GTrimPatterns {
    public static final List<ResourceKey<TrimPattern>> TRIM_PATTERNS = Lists.newArrayList();
    public static final ResourceKey<TrimPattern> FAITH = GTrimPatterns.registryKey("faith");

    public static void bootstrap(BootstrapContext<TrimPattern> context) {
        GTrimPatterns.register(context, (Item)GItems.FAITH_ARMOR_TRIM_SMITHING_TEMPLATE.get(), FAITH);
    }

    public static void register(BootstrapContext<TrimPattern> bootstrapContext, Item item, ResourceKey<TrimPattern> resourceKey) {
        TrimPattern trimPattern = new TrimPattern(resourceKey.location(), BuiltInRegistries.ITEM.wrapAsHolder((Object)item), (Component)Component.translatable((String)Util.makeDescriptionId((String)"trim_pattern", (ResourceLocation)resourceKey.location())), false);
        bootstrapContext.register(resourceKey, (Object)trimPattern);
    }

    private static ResourceKey<TrimPattern> registryKey(String string) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.TRIM_PATTERN, (ResourceLocation)Galosphere.id(string));
        TRIM_PATTERNS.add((ResourceKey<TrimPattern>)key);
        return key;
    }
}

