/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.init.GBuiltinLootTables;
import net.orcinus.galosphere.init.GRegistries;
import net.orcinus.galosphere.util.quests.MiningQuest;

public class GMiningQuests {
    public static final List<ResourceKey<MiningQuest>> QUESTS = Lists.newArrayList();
    public static final ResourceKey<MiningQuest> COMMON = GMiningQuests.register("common");
    public static final ResourceKey<MiningQuest> RARE = GMiningQuests.register("rare");
    public static final ResourceKey<MiningQuest> EPIC = GMiningQuests.register("epic");

    public static void bootstrap(BootstrapContext<MiningQuest> context) {
        context.register(COMMON, (Object)new MiningQuest(9, Rarity.COMMON, GBuiltinLootTables.MINING_QUESTS_COMMON_REQUEST, GBuiltinLootTables.MINING_QUESTS_COMMON_GIFT));
        context.register(RARE, (Object)new MiningQuest(7, Rarity.RARE, GBuiltinLootTables.MINING_QUESTS_RARE_REQUEST, GBuiltinLootTables.MINING_QUESTS_RARE_GIFT));
        context.register(EPIC, (Object)new MiningQuest(6, Rarity.EPIC, GBuiltinLootTables.MINING_QUESTS_EPIC_REQUEST, GBuiltinLootTables.MINING_QUESTS_EPIC_GIFT));
    }

    public static ResourceKey<MiningQuest> register(String name) {
        ResourceKey key = ResourceKey.create(GRegistries.MINING_QUEST, (ResourceLocation)Galosphere.id(name));
        QUESTS.add((ResourceKey<MiningQuest>)key);
        return key;
    }
}

