/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks.mole;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.orcinus.galosphere.blocks.blockentities.MoleBurrowBlockEntity;
import net.orcinus.galosphere.entities.Mole;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GMemoryModuleTypes;

public class ReturnBurrow
extends Behavior<Mole> {
    public ReturnBurrow() {
        super((Map)ImmutableMap.of(GMemoryModuleTypes.MOLE_RETURNING.get(), (Object)MemoryStatus.VALUE_PRESENT), 600);
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Mole livingEntity) {
        MoleBurrowBlockEntity moleBurrowBlock;
        boolean flag1;
        BlockPos pos = livingEntity.getBurrowPos();
        if (pos == null) {
            return false;
        }
        boolean flag = !serverLevel.getBlockState(pos).is((Block)GBlocks.MOLE_BURROW.get());
        BlockEntity blockEntity = serverLevel.getBlockEntity(pos);
        boolean bl = flag1 = blockEntity instanceof MoleBurrowBlockEntity && !(moleBurrowBlock = (MoleBurrowBlockEntity)blockEntity).isEmpty();
        if (flag || flag1) {
            livingEntity.setBurrowPos(null);
            return false;
        }
        return true;
    }

    protected boolean canStillUse(ServerLevel serverLevel, Mole livingEntity, long l) {
        MoleBurrowBlockEntity moleBurrowBlock;
        BlockEntity blockEntity;
        BlockPos pos = livingEntity.getBurrowPos();
        if (pos != null && (!serverLevel.getBlockState(pos).is((Block)GBlocks.MOLE_BURROW.get()) || (blockEntity = serverLevel.getBlockEntity(pos)) instanceof MoleBurrowBlockEntity && !(moleBurrowBlock = (MoleBurrowBlockEntity)blockEntity).isEmpty())) {
            livingEntity.setBurrowPos(null);
            return false;
        }
        if (livingEntity.getBrain().hasMemoryValue(GMemoryModuleTypes.MOLE_DIGGING.get())) {
            return livingEntity.getBrain().getTimeUntilExpiry(GMemoryModuleTypes.MOLE_DIGGING.get()) > 0L;
        }
        return this.checkExtraStartConditions(serverLevel, livingEntity);
    }

    protected void tick(ServerLevel serverLevel, Mole livingEntity, long l) {
        if (livingEntity.getBrain().hasMemoryValue(GMemoryModuleTypes.MOLE_DIGGING.get())) {
            livingEntity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
            livingEntity.transitionTo(Mole.State.DIGGING);
            return;
        }
        if (this.canBurrow(livingEntity)) {
            livingEntity.getBrain().setMemoryWithExpiry(GMemoryModuleTypes.MOLE_DIGGING.get(), (Object)Unit.INSTANCE, 40L);
            return;
        }
        Optional.ofNullable(livingEntity.getBurrowPos()).ifPresent(blockPos -> livingEntity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(blockPos.above(), 1.65f, 0)));
    }

    protected void stop(ServerLevel serverLevel, Mole livingEntity, long l) {
        MoleBurrowBlockEntity moleBurrowBlock;
        BlockEntity blockEntity;
        if (livingEntity.getBurrowPos() != null && (blockEntity = serverLevel.getBlockEntity(livingEntity.getBurrowPos())) instanceof MoleBurrowBlockEntity && (moleBurrowBlock = (MoleBurrowBlockEntity)blockEntity).isEmpty()) {
            moleBurrowBlock.addMole((Entity)livingEntity);
        } else {
            livingEntity.transitionTo(Mole.State.IDLING);
        }
    }

    private boolean canBurrow(Mole mole) {
        if (mole.getBurrowPos() == null) {
            return false;
        }
        BlockPos blockPos = mole.blockPosition();
        BlockPos above = mole.getBurrowPos().above();
        return blockPos.equals((Object)above);
    }
}

