/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks.mole;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.orcinus.galosphere.entities.Mole;
import net.orcinus.galosphere.init.GMemoryModuleTypes;

public class MoleSniffing
extends Behavior<Mole> {
    public MoleSniffing() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.IS_PANICKING, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.SNIFF_COOLDOWN, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, GMemoryModuleTypes.MOLE_DIGGING.get(), (Object)MemoryStatus.VALUE_ABSENT, GMemoryModuleTypes.MOLE_DIGGING_TARGET.get(), (Object)MemoryStatus.VALUE_ABSENT, GMemoryModuleTypes.MOLE_RETURNING.get(), (Object)MemoryStatus.VALUE_ABSENT), 40);
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Mole mole) {
        return mole.canSniff();
    }

    protected boolean canStillUse(ServerLevel serverLevel, Mole mole, long l) {
        return mole.canSniff();
    }

    protected void start(ServerLevel serverLevel, Mole livingEntity, long l) {
        livingEntity.transitionTo(Mole.State.SNIFFING);
    }

    protected void stop(ServerLevel serverLevel, Mole livingEntity, long l) {
        boolean bl = this.timedOut(l);
        livingEntity.transitionTo(Mole.State.IDLING);
        if (bl) {
            livingEntity.calculateDigPosition().ifPresent(blockPos -> {
                livingEntity.getBrain().setMemory(GMemoryModuleTypes.MOLE_DIGGING_TARGET.get(), blockPos);
                livingEntity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(blockPos, 1.25f, 0));
            });
        }
    }
}

