/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks.mole;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.orcinus.galosphere.entities.Mole;
import net.orcinus.galosphere.init.GMemoryModuleTypes;

public class MoleSearching
extends Behavior<Mole> {
    public MoleSearching() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.SNIFF_COOLDOWN, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.IS_PANICKING, (Object)MemoryStatus.VALUE_ABSENT, GMemoryModuleTypes.MOLE_DIGGING.get(), (Object)MemoryStatus.VALUE_ABSENT, GMemoryModuleTypes.MOLE_DIGGING_TARGET.get(), (Object)MemoryStatus.VALUE_PRESENT), 200);
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Mole mole) {
        return mole.canSniff();
    }

    protected boolean canStillUse(ServerLevel serverLevel, Mole mole, long l) {
        if (!mole.canSniff()) {
            mole.transitionTo(Mole.State.IDLING);
            return false;
        }
        Optional<BlockPos> optional = mole.getBrain().getMemory(MemoryModuleType.WALK_TARGET).map(WalkTarget::getTarget).map(PositionTracker::currentBlockPosition);
        Optional optional2 = mole.getBrain().getMemory(GMemoryModuleTypes.MOLE_DIGGING_TARGET.get());
        if (optional.isEmpty() || optional2.isEmpty()) {
            return false;
        }
        return ((BlockPos)optional2.get()).equals((Object)optional.get());
    }

    protected void start(ServerLevel serverLevel, Mole mole, long l) {
        mole.transitionTo(Mole.State.SNIFFING);
    }

    protected void stop(ServerLevel serverLevel, Mole mole, long l) {
        if (mole.canDig()) {
            mole.getBrain().setMemory(GMemoryModuleTypes.MOLE_DIGGING.get(), (Object)Unit.INSTANCE);
        }
        mole.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        mole.getBrain().eraseMemory(GMemoryModuleTypes.MOLE_DIGGING_TARGET.get());
    }
}

