/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.sensors;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;

public class NearestBlockSensor
extends Sensor<Mob> {
    private static final int DEFAULT_RANGE = 8;
    private final MemoryModuleType<BlockPos> memory;
    private final MemoryModuleType<?> required;
    private final NearestBlockCondition filter;
    private final int range;

    public NearestBlockSensor(MemoryModuleType<BlockPos> memory, NearestBlockCondition filter) {
        this(memory, memory, filter, 8);
    }

    public NearestBlockSensor(MemoryModuleType<BlockPos> memory, MemoryModuleType<?> required, NearestBlockCondition filter) {
        this(memory, required, filter, 8);
    }

    public NearestBlockSensor(MemoryModuleType<BlockPos> memory, NearestBlockCondition filter, int range) {
        this(memory, memory, filter, range);
    }

    public NearestBlockSensor(MemoryModuleType<BlockPos> memory, MemoryModuleType<?> required, NearestBlockCondition filter, int range) {
        this.memory = memory;
        this.required = required;
        this.filter = filter;
        this.range = range;
    }

    protected void doTick(ServerLevel serverLevel, Mob entity) {
        ArrayList poses = Lists.newArrayList();
        for (int x = -this.range; x <= this.range; ++x) {
            for (int z = -this.range; z <= this.range; ++z) {
                for (int y = -this.range; y <= this.range; ++y) {
                    BlockPos pos = BlockPos.containing((double)(entity.getX() + (double)x), (double)(entity.getY() + (double)y), (double)(entity.getZ() + (double)z));
                    if (!this.filter.test((Level)serverLevel, pos, (LivingEntity)entity)) continue;
                    poses.add(pos);
                }
            }
        }
        if (!poses.isEmpty()) {
            poses.sort(Comparator.comparingDouble(arg_0 -> ((BlockPos)entity.blockPosition()).distSqr(arg_0)));
            for (BlockPos pos : poses) {
                boolean hasValue = entity.getBrain().hasMemoryValue(this.memory);
                boolean canReach = Optional.ofNullable(entity.getNavigation().createPath(pos, 0)).map(Path::canReach).orElse(false);
                if (hasValue || !canReach) continue;
                entity.getBrain().setMemory(this.memory, (Object)pos);
            }
        } else {
            entity.getBrain().eraseMemory(this.memory);
        }
    }

    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(this.required);
    }

    public static interface NearestBlockCondition {
        public boolean test(Level var1, BlockPos var2, LivingEntity var3);
    }
}

