/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.orcinus.galosphere.api.BottlePickable;
import net.orcinus.galosphere.api.Spectatable;
import net.orcinus.galosphere.entities.ai.SpectreAi;
import net.orcinus.galosphere.init.GAttachmentTypes;
import net.orcinus.galosphere.init.GBlockTags;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.init.GSensorTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.items.components.SpectreBound;
import net.orcinus.galosphere.network.SendPerspectivePacket;
import org.jetbrains.annotations.Nullable;

public class Spectre
extends Animal
implements FlyingAnimal,
BottlePickable,
Spectatable {
    private static final EntityDataAccessor<Optional<UUID>> MANIPULATOR = SynchedEntityData.defineId(Spectre.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> CAN_BE_MANIPULATED = SynchedEntityData.defineId(Spectre.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FROM_BOTTLE = SynchedEntityData.defineId(Spectre.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final ImmutableList<SensorType<? extends Sensor<? super Spectre>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)SensorType.IS_IN_WATER, GSensorTypes.SPECTRE_TEMPTATIONS.get());
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryModuleType.BREED_TARGET, (Object)MemoryModuleType.IS_PREGNANT, (Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, (Object[])new MemoryModuleType[]{MemoryModuleType.IS_TEMPTED, MemoryModuleType.IS_PANICKING, GMemoryModuleTypes.NEAREST_LICHEN_MOSS.get()});

    public Spectre(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
    }

    public float getWalkTargetValue(BlockPos p_27573_, LevelReader p_27574_) {
        return 0.0f;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(GItemTags.SPECTRE_TEMPT_ITEMS);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob p_146744_) {
        return (AgeableMob)GEntityTypes.SPECTRE.get().create((Level)serverLevel);
    }

    public void spawnChildFromBreeding(ServerLevel serverLevel, Animal animal) {
        ServerPlayer serverPlayer = this.getLoveCause();
        if (serverPlayer == null) {
            serverPlayer = animal.getLoveCause();
        }
        if (serverPlayer != null) {
            serverPlayer.awardStat(Stats.ANIMALS_BRED);
            CriteriaTriggers.BRED_ANIMALS.trigger(serverPlayer, (Animal)this, animal, null);
        }
        this.setAge(6000);
        animal.setAge(6000);
        this.resetLove();
        animal.resetLove();
        this.getBrain().setMemory(MemoryModuleType.IS_PREGNANT, (Object)Unit.INSTANCE);
        serverLevel.broadcastEntityEvent((Entity)this, (byte)18);
        if (serverLevel.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            serverLevel.addFreshEntity((Entity)new ExperienceOrb((Level)serverLevel, this.getX(), this.getY(), this.getZ(), this.getRandom().nextInt(7) + 1));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MANIPULATOR, Optional.empty());
        builder.define(CAN_BE_MANIPULATED, (Object)false);
        builder.define(FROM_BOTTLE, (Object)false);
    }

    public static boolean checkSpectreSpawnRules(EntityType<? extends LivingEntity> type, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(GBlockTags.SPECTRES_SPAWNABLE_ON);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        UUID uuid;
        super.readAdditionalSaveData(tag);
        if (tag.hasUUID("Manipulator")) {
            uuid = tag.getUUID("Manipulator");
        } else {
            String s = tag.getString("Manipulator");
            uuid = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)s);
        }
        if (uuid != null) {
            this.setManipulatorUUID(uuid);
        }
        this.setFromBottle(tag.getBoolean("FromBottle"));
        this.setCanBeManipulated(tag.getBoolean("CanBeManipulated"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.getManipulatorUUID() != null) {
            tag.putUUID("Manipulator", this.getManipulatorUUID());
        }
        tag.putBoolean("FromBottle", this.fromBottle());
        tag.putBoolean("CanBeManipulated", this.canBeManipulated());
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return GSoundEvents.SPECTRE_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return GSoundEvents.SPECTRE_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return GSoundEvents.SPECTRE_DEATH.get();
    }

    @Override
    @Nullable
    public UUID getManipulatorUUID() {
        return ((Optional)this.entityData.get(MANIPULATOR)).orElse(null);
    }

    @Override
    public void setManipulatorUUID(@Nullable UUID uuid) {
        this.entityData.set(MANIPULATOR, Optional.ofNullable(uuid));
    }

    @Override
    public void spectateTick(UUID uuid) {
        Player player = this.level().getPlayerByUUID(uuid);
        if (player != null) {
            player.xxa = 0.0f;
            player.zza = 0.0f;
            player.setJumping(false);
            this.copyPlayerRotation((LivingEntity)this, player);
            if (!player.getUseItem().is(GItems.SPECTRE_BOUND_SPYGLASS) || this.isDeadOrDying()) {
                this.setManipulatorUUID(null);
                if (this.level().isClientSide) {
                    this.stopUsingSpyglass(player);
                } else {
                    player.setData(GAttachmentTypes.IS_SPECTRE_BOUNDED, (Object)false);
                    player.playNotifySound(GSoundEvents.SPECTRE_MANIPULATE_END.get(), this.getSoundSource(), 1.0f, 1.0f);
                }
            }
        }
        if (!this.level().isClientSide() && player == null) {
            this.entityData.set(MANIPULATOR, Optional.empty());
        }
    }

    public boolean canBeManipulated() {
        return (Boolean)this.entityData.get(CAN_BE_MANIPULATED);
    }

    public void setCanBeManipulated(boolean canBeManipulated) {
        this.entityData.set(CAN_BE_MANIPULATED, (Object)canBeManipulated);
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation flyingPathNavigation = new FlyingPathNavigation((Mob)this, level);
        flyingPathNavigation.setCanOpenDoors(false);
        flyingPathNavigation.setCanFloat(true);
        return flyingPathNavigation;
    }

    public void tick() {
        super.tick();
        if (this.canBeManipulated() && this.random.nextFloat() < 0.05f) {
            for (int i = 0; i < this.random.nextInt(2) + 1; ++i) {
                this.spawnFluidParticle(this.level(), this.getX() - (double)0.3f, this.getX() + (double)0.3f, this.getZ() - (double)0.3f, this.getZ() + (double)0.3f, this.getY(0.5), (ParticleOptions)GParticleTypes.ALLURITE_RAIN.get());
            }
        }
    }

    private void spawnFluidParticle(Level world, double minX, double maxX, double minZ, double maxZ, double y, ParticleOptions options) {
        world.addParticle(options, Mth.lerp((double)world.random.nextDouble(), (double)minX, (double)maxX), y, Mth.lerp((double)world.random.nextDouble(), (double)minZ, (double)maxZ), 0.0, 0.0, 0.0);
    }

    protected void playStepSound(BlockPos blockPos, BlockState blockState) {
    }

    protected void checkFallDamage(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    protected boolean isFlapping() {
        return this.isFlying();
    }

    protected Brain.Provider<Spectre> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return SpectreAi.makeBrain((Brain<Spectre>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Spectre> getBrain() {
        return super.getBrain();
    }

    protected void customServerAiStep() {
        this.level().getProfiler().push("spectreBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        this.level().getProfiler().pop();
        this.level().getProfiler().push("spectreActivityUpdate");
        SpectreAi.updateActivity(this);
        this.level().getProfiler().pop();
        super.customServerAiStep();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.FLYING_SPEED, (double)0.6f).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide() || this.matchesClientPlayerUUID()) {
            ((Optional)this.entityData.get(MANIPULATOR)).ifPresent(this::spectateTick);
        }
    }

    public boolean removeWhenFarAway(double d) {
        return !this.hasCustomName() && !this.fromBottle();
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBottle();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void stopUsingSpyglass(Player player) {
        Minecraft client = Minecraft.getInstance();
        if (client.player == player) {
            client.setCameraEntity((Entity)player);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean matchesClientPlayerUUID() {
        return Minecraft.getInstance().player != null && Minecraft.getInstance().player.getUUID().equals(this.getManipulatorUUID());
    }

    public void travel(Vec3 velocity) {
        if (this.getManipulatorUUID() == null) {
            super.travel(velocity);
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        ItemStack stack = player.getItemInHand(interactionHand);
        if (this.canBeManipulated() && (stack.is((Item)GItems.SPECTRE_BOUND_SPYGLASS.get()) || stack.is(Items.SPYGLASS))) {
            this.playSound(GSoundEvents.SPECTRE_LOCK_TO_SPYGLASS.get(), 1.0f, 1.0f);
            ItemStack spectreBoundedSpyglass = new ItemStack((ItemLike)GItems.SPECTRE_BOUND_SPYGLASS.get());
            if (this.hasCustomName()) {
                spectreBoundedSpyglass.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
            }
            spectreBoundedSpyglass.set(GDataComponents.SPECTRE_BOUND.get(), (Object)new SpectreBound(this.getId(), this.getUUID()));
            player.setItemInHand(interactionHand, spectreBoundedSpyglass);
            this.setCanBeManipulated(false);
            return InteractionResult.SUCCESS;
        }
        if (stack.is(Items.GLASS_BOTTLE)) {
            this.level().playSound(player, player.getX(), player.getY(), player.getZ(), GSoundEvents.SPECTRE_BOTTLE_FILL.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            if (!this.level().isClientSide()) {
                this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
                ItemStack itemStack2 = new ItemStack((ItemLike)GItems.BOTTLE_OF_SPECTRE.get());
                CompoundTag compoundTag = new CompoundTag();
                this.save(compoundTag);
                itemStack2.set(GDataComponents.BOTTLE_ENTITY_DATA.get(), (Object)CustomData.of((CompoundTag)compoundTag));
                player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)itemStack2));
                this.discard();
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.is((Item)GItems.ALLURITE_SHARD.get()) && this.getManipulatorUUID() == null && !this.canBeManipulated()) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            this.setCanBeManipulated(true);
            this.playSound(GSoundEvents.SPECTRE_RECEIVE_ITEM.get(), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, interactionHand);
    }

    public void setCamera(Player player) {
        if (!this.level().isClientSide()) {
            player.zza = 0.0f;
            player.setData(GAttachmentTypes.IS_SPECTRE_BOUNDED, (Object)true);
            this.setManipulatorUUID(player.getUUID());
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new SendPerspectivePacket(player.getUUID(), this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.playSound(GSoundEvents.SPECTRE_MANIPULATE_BEGIN.get(), 1.0f, 1.0f);
        }
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    @Override
    public boolean fromBottle() {
        return (Boolean)this.entityData.get(FROM_BOTTLE);
    }

    @Override
    public void setFromBottle(boolean fromBottle) {
        this.entityData.set(FROM_BOTTLE, (Object)fromBottle);
    }
}

