/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import java.util.Collection;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.orcinus.galosphere.init.GAttachmentTypes;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.network.ClientboundBoostPlayerPacket;
import org.jetbrains.annotations.Nullable;

public class RopeDartProjectile
extends AbstractArrow {
    private final Function<Player, NonNullList<ItemStack>> itemsFunction = player -> {
        NonNullList list = NonNullList.create();
        list.add((Object)player.getMainHandItem());
        list.add((Object)player.getOffhandItem());
        list.addAll((Collection)player.getInventory().items);
        return list;
    };

    public RopeDartProjectile(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public RopeDartProjectile(Level level, Player player) {
        this(GEntityTypes.ROPE_DART.get(), level);
        this.setOwner((Entity)player);
        this.setPos(player.getX(), player.getEyeY() - 0.1, player.getZ());
        this.setDeltaMovement(player.getViewVector(1.0f).scale(3.0));
    }

    public void setOwner(@Nullable Entity entity) {
        super.setOwner(entity);
        this.updateOwnerInfo(this);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)GItems.ROPE_DART.get());
    }

    protected double getDefaultGravity() {
        return 0.03;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    public void shootFromRotation(Entity entity, float f, float g, float h, float i, float j) {
        float k = -Mth.sin((float)(g * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        float l = -Mth.sin((float)((f + h) * ((float)Math.PI / 180)));
        float m = Mth.cos((float)(g * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        this.shoot(k, l, m, i, j);
        Vec3 vec3 = entity.getKnownMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(vec3.x, entity.onGround() ? 0.0 : vec3.y, vec3.z));
    }

    public boolean shouldRenderAtSqrDistance(double d) {
        return true;
    }

    protected void lerpPositionAndRotationStep(int i, double d, double e, double f, double g, double h) {
    }

    public void tick() {
        Player player = this.getPlayerOwner();
        if (!(this.level().isClientSide || player != null && player.isAlive())) {
            this.discard();
            return;
        }
        if (player != null) {
            if (player.getDeltaMovement().y() > -0.3) {
                player.fallDistance = 0.0f;
            }
            if (player.isHolding((Item)GItems.ROPE_DART.get())) {
                boolean mainHand = player.getMainHandItem().is((Item)GItems.ROPE_DART.get());
                InteractionHand interactionHand = mainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                InteractionHand hand = player.getUsedItemHand();
                if (hand != interactionHand) {
                    player.stopUsingItem();
                    this.discard();
                    return;
                }
            }
            if (player.isRemoved() || !player.isAlive() || !player.isHolding((Item)GItems.ROPE_DART.get())) {
                player.stopUsingItem();
                this.discard();
                return;
            }
            HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
            if (hitResult.getType() != HitResult.Type.MISS) {
                this.onHit(hitResult);
            }
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                this.setPos(blockHitResult.getLocation());
                this.checkInsideBlocks();
            }
        } else {
            this.discard();
            return;
        }
        super.tick();
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        Player owner = this.getPlayerOwner();
        if (owner != null) {
            Vec3 pos = blockHitResult.getLocation();
            Vec3 eyePos = owner.getEyePosition();
            Vec3 adjustedMovement = owner.getDeltaMovement().add(pos.subtract(eyePos).normalize().scale(0.2));
            owner.setDeltaMovement(adjustedMovement);
            owner.fallDistance = 0.0f;
        }
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public void remove(Entity.RemovalReason removalReason) {
        Player player = this.getPlayerOwner();
        if (this.inGround()) {
            this.onBreak(player);
        }
        this.updateOwnerInfo(null);
        super.remove(removalReason);
    }

    private void onBreak(Player player) {
        Level level;
        if (player != null) {
            if (!player.getAbilities().instabuild) {
                this.itemsFunction.apply(player).stream().filter(itemStack -> itemStack.is((Item)GItems.ROPE_DART.get())).findFirst().ifPresent(itemStack -> itemStack.shrink(1));
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ClientboundBoostPlayerPacket(1.35), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)GBlocks.ALLURITE_BLOCK.get()).defaultBlockState()), this.getX(), this.getY(), this.getZ(), 8, 0.1, 0.1, 0.1, 0.1);
        }
    }

    public void onClientRemoval() {
        if (this.level().isClientSide() && this.inGround()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), GSoundEvents.ROPE_DART_BREAK.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        }
        this.updateOwnerInfo(null);
    }

    private void updateOwnerInfo(@Nullable RopeDartProjectile hook) {
        Player player = this.getPlayerOwner();
        if (player == null) {
            return;
        }
        if (hook != null) {
            player.setData(GAttachmentTypes.ROPE_DART, (Object)hook);
        } else {
            player.removeData(GAttachmentTypes.ROPE_DART);
        }
    }

    @Nullable
    public Player getPlayerOwner() {
        Player player;
        Entity entity = this.getOwner();
        return entity instanceof Player ? (player = (Player)entity) : null;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        Entity entity = this.getOwner();
        int id = entity == null ? this.getId() : entity.getId();
        return new ClientboundAddEntityPacket((Entity)this, serverEntity, id);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket clientboundAddEntityPacket) {
        super.recreateFromPacket(clientboundAddEntityPacket);
        if (this.getPlayerOwner() == null) {
            this.discard();
        }
    }

    public boolean inGround() {
        return this.inGround;
    }

    protected boolean tryPickup(Player player) {
        return false;
    }
}

