/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.entities.PinkSaltShard;
import net.orcinus.galosphere.entities.Preserved;
import net.orcinus.galosphere.init.GCriteriaTriggers;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.util.GEnchantmentHelper;
import org.jetbrains.annotations.Nullable;

public class PinkSaltPillar
extends Entity
implements TraceableEntity {
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.defineId(PinkSaltPillar.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.defineId(PinkSaltPillar.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 22;
    public static final float DEFAULT_DAMAGE = 3.0f;
    private float damage = 3.0f;
    public AnimationState emergeAnimationState = new AnimationState();
    public AnimationState retractAnimationState = new AnimationState();

    public PinkSaltPillar(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public PinkSaltPillar(Level level, double d, double e, double f, float g, int warmupDelayTicks, float damage, LivingEntity livingEntity) {
        this(GEntityTypes.PINK_SALT_PILLAR.get(), level);
        this.warmupDelayTicks = warmupDelayTicks;
        this.damage = damage;
        this.setOwner(livingEntity);
        this.setYRot(g * 57.295776f);
        this.setPos(d, e, f);
    }

    public PinkSaltPillar(Level level, double d, double e, double f, float g, int warmupDelayTicks, float damage, LivingEntity livingEntity, ItemStack itemStack) {
        this(GEntityTypes.PINK_SALT_PILLAR.get(), level);
        this.warmupDelayTicks = warmupDelayTicks;
        this.damage = damage;
        this.setOwner(livingEntity);
        this.setYRot(g * 57.295776f);
        this.setPos(d, e, f);
        this.entityData.set(ITEM, (Object)itemStack.copy());
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.lifeTicks = 22 * (GEnchantmentHelper.getSustainingTicks(serverLevel, itemStack, this) / 2 + 1);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ACTIVE, (Object)false);
        builder.define(ITEM, (Object)ItemStack.EMPTY);
    }

    public void setOwner(@Nullable LivingEntity livingEntity) {
        this.owner = livingEntity;
        this.ownerUUID = livingEntity == null ? null : livingEntity.getUUID();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.level() instanceof ServerLevel && (entity = ((ServerLevel)this.level()).getEntity(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        UUID uUID;
        this.warmupDelayTicks = compoundTag.getInt("Warmup");
        this.lifeTicks = compoundTag.getInt("LifeTicks");
        this.damage = compoundTag.getFloat("Damage");
        this.setActive(compoundTag.getBoolean("Active"));
        RegistryOps registryOps = this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (compoundTag.contains("TabletItem", 10)) {
            this.entityData.set(ITEM, (Object)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compoundTag.getCompound("TabletItem")).orElse(PinkSaltPillar.getDefaultItem()));
        } else {
            this.entityData.set(ITEM, (Object)PinkSaltPillar.getDefaultItem());
        }
        if (compoundTag.hasUUID("Owner")) {
            uUID = compoundTag.getUUID("Owner");
        } else {
            String string = compoundTag.getString("Owner");
            uUID = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)string);
        }
        if (uUID != null) {
            this.ownerUUID = uUID;
        }
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putInt("Warmup", this.warmupDelayTicks);
        compoundTag.putInt("LifeTicks", this.lifeTicks);
        compoundTag.putFloat("Damage", this.damage);
        compoundTag.putBoolean("Active", this.isActive());
        ItemStack itemStack = (ItemStack)this.entityData.get(ITEM);
        if (!itemStack.isEmpty()) {
            compoundTag.put("TabletItem", ((ItemStack)this.entityData.get(ITEM)).save((HolderLookup.Provider)this.registryAccess()));
        }
        if (this.ownerUUID != null) {
            compoundTag.putUUID("Owner", this.ownerUUID);
        }
    }

    private static ItemStack getDefaultItem() {
        return new ItemStack((ItemLike)GItems.SALTBOUND_TABLET.get());
    }

    private void setActive(boolean active) {
        this.entityData.set(ACTIVE, (Object)active);
    }

    public boolean isActive() {
        return (Boolean)this.entityData.get(ACTIVE);
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            Level stack;
            Vec3 normalizedDirection;
            ServerLevel serverLevel = (ServerLevel)level;
            List arrows = this.level().getEntitiesOfClass(Arrow.class, this.getBoundingBox().inflate(1.2));
            for (Object arrow : arrows) {
                Vec3 selfPos = this.position().add(0.0, (double)1.6f, 0.0);
                Vec3 enemyPos = arrow.getEyePosition().subtract(selfPos);
                normalizedDirection = enemyPos.normalize();
                double knockbackX = 0.15;
                double knockbackY = 0.15;
                arrow.setDeltaMovement(arrow.getDeltaMovement().add(normalizedDirection.x() * knockbackY, normalizedDirection.y() * knockbackX, normalizedDirection.z() * knockbackY));
            }
            if (--this.warmupDelayTicks < 0) {
                int ruptureLevel;
                boolean fracture;
                List list = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.2, 0.0, 0.2));
                for (LivingEntity livingEntity : list) {
                    if (this.getOwner() instanceof Berserker && livingEntity instanceof Preserved) continue;
                    this.dealDamageTo(livingEntity);
                    if (livingEntity.isAlive() || !livingEntity.getType().equals(EntityType.EVOKER) || !((normalizedDirection = this.getOwner()) instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)normalizedDirection;
                    GCriteriaTriggers.SALTBOUND_KILL_EVOKER.get().trigger(serverPlayer);
                }
                if (!this.sentSpikeEvent) {
                    this.setActive(true);
                    this.level().broadcastEntityEvent((Entity)this, (byte)4);
                    this.sentSpikeEvent = true;
                }
                boolean bl = fracture = (ruptureLevel = GEnchantmentHelper.hasRupture(serverLevel, (ItemStack)(stack = (ItemStack)this.entityData.get(ITEM)), this)) > 0;
                if (!fracture) {
                    if (this.lifeTicks == 4) {
                        this.level().broadcastEntityEvent((Entity)this, (byte)6);
                    }
                    if (--this.lifeTicks < 0) {
                        this.discard();
                    }
                } else if (--this.lifeTicks < 0) {
                    for (int i = 0; i < ruptureLevel + 2; ++i) {
                        PinkSaltShard pinkSaltShard = new PinkSaltShard(this.getOwner(), this.level());
                        pinkSaltShard.moveTo(Vec3.atCenterOf((Vec3i)this.blockPosition()));
                        Vec3 vec3 = new Vec3(this.random.nextGaussian(), this.random.nextGaussian(), this.random.nextGaussian()).normalize();
                        Vec3 vec31 = vec3.scale(0.75);
                        pinkSaltShard.setDeltaMovement(vec31);
                        this.level().addFreshEntity((Entity)pinkSaltShard);
                    }
                    this.discard();
                }
            }
            if (this.warmupDelayTicks == 0 && (stack = this.level()) instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)stack;
                Vec3 pos = this.position();
                server.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, server.getBlockState(this.getOnPos())), pos.x, pos.y, pos.z, 12, 0.4, 0.0, 0.4, 0.1);
                if (this.isUnderWater()) {
                    server.sendParticles((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, pos.x, pos.y, pos.z, 8, 0.3, 0.0, 0.3, 0.3);
                }
            }
        }
    }

    private void dealDamageTo(LivingEntity livingEntity) {
        LivingEntity livingEntity2 = this.getOwner();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (livingEntity2 != null && player.getUUID().equals(livingEntity2.getUUID())) {
                return;
            }
        }
        if (!livingEntity.isAlive() || livingEntity.isInvulnerable() || livingEntity == livingEntity2) {
            return;
        }
        if (livingEntity2 == null) {
            livingEntity.hurt(this.damageSources().magic(), this.damage);
        } else {
            ServerLevel serverLevel;
            if (livingEntity2.isAlliedTo((Entity)livingEntity)) {
                return;
            }
            livingEntity.hurt(this.damageSources().indirectMagic((Entity)this, (Entity)livingEntity2), this.damage);
            ItemStack stack = (ItemStack)this.entityData.get(ITEM);
            Level level = this.level();
            if (level instanceof ServerLevel && GEnchantmentHelper.hasEnfeeble(serverLevel = (ServerLevel)level, stack, this) > 0) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100));
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        return !(source.getEntity() instanceof Arrow);
    }

    public void handleEntityEvent(byte b) {
        super.handleEntityEvent(b);
        if (b == 4) {
            this.emergeAnimationState.start(this.tickCount);
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), GSoundEvents.PINK_SALT_PILLAR_EMERGE.get(), this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.2f + 0.85f, false);
            }
        } else if (b == 6) {
            this.retractAnimationState.start(this.tickCount);
        }
    }
}

