/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.api.HaliteCurse;
import net.orcinus.galosphere.entities.ai.BerserkerAi;
import net.orcinus.galosphere.init.GEntityTypeTags;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import org.jetbrains.annotations.Nullable;

public class Berserker
extends Monster {
    private static final EntityDataAccessor<String> PHASE = SynchedEntityData.defineId(Berserker.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> STATIONARY_TICKS = SynchedEntityData.defineId(Berserker.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> SHEDDING = SynchedEntityData.defineId(Berserker.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public AnimationState roarAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState punchAnimationState = new AnimationState();
    public AnimationState impalingAnimationState = new AnimationState();
    public AnimationState summoningAnimationState = new AnimationState();
    public AnimationState salifyingAnimationState = new AnimationState();

    public Berserker(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.lookControl = new BerserkerLookControl((Mob)this);
    }

    public boolean isInvulnerableTo(DamageSource damageSource) {
        if (this.getStationaryTicks() > 0) {
            Entity entity = damageSource.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.getAbilities().instabuild;
            }
            return true;
        }
        return super.isInvulnerableTo(damageSource);
    }

    public float maxUpStep() {
        return 1.0f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PHASE, (Object)Phase.IDLING.name());
        builder.define(STATIONARY_TICKS, (Object)0);
        builder.define(SHEDDING, (Object)false);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        String phase = compoundTag.getString("Phase");
        if (!phase.isEmpty()) {
            this.setPhase(Phase.valueOf(phase));
        }
        this.setStationaryTicks(compoundTag.getInt("StationaryTicks"));
        this.setShedding(compoundTag.getBoolean("Shedding"));
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putString("Phase", this.getPhase().name());
        compoundTag.putInt("StationaryTicks", this.getStationaryTicks());
        compoundTag.putBoolean("Shedding", this.isShedding());
    }

    public boolean shouldAttack() {
        return this.getPhase() == Phase.IDLING && !this.isStationary();
    }

    public int getStage() {
        float health = this.getHealth() / this.getMaxHealth();
        if (this.isStationary()) {
            return 3;
        }
        if (health > 0.66f) {
            return 0;
        }
        if (health <= 0.66f && health > 0.33f) {
            return 1;
        }
        return 2;
    }

    public void setShedding(boolean shedding) {
        this.entityData.set(SHEDDING, (Object)shedding);
    }

    public boolean isShedding() {
        return (Boolean)this.entityData.get(SHEDDING);
    }

    public void setStationaryTicks(int stationaryTicks) {
        this.entityData.set(STATIONARY_TICKS, (Object)stationaryTicks);
    }

    public int getStationaryTicks() {
        return (Integer)this.entityData.get(STATIONARY_TICKS);
    }

    public void setPhase(Phase phase) {
        if (phase == Phase.IDLING) {
            this.setPose(Pose.STANDING);
        } else if (phase == Phase.SMASH) {
            this.level().broadcastEntityEvent((Entity)this, (byte)4);
        } else if (phase == Phase.UNDERMINE) {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        } else if (phase == Phase.SUMMONING) {
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        } else if (phase == Phase.HALITE_ATTACK) {
            this.level().broadcastEntityEvent((Entity)this, (byte)8);
        }
        this.entityData.set(PHASE, (Object)phase.name());
    }

    public void handleEntityEvent(byte b) {
        if (b == 4) {
            this.attackAnimationState.start(this.tickCount);
        } else if (b == 5) {
            this.punchAnimationState.start(this.tickCount);
        } else if (b == 6) {
            this.impalingAnimationState.start(this.tickCount);
        } else if (b == 7) {
            this.summoningAnimationState.start(this.tickCount);
        } else if (b == 8) {
            this.salifyingAnimationState.start(this.tickCount);
        } else if (b == 32) {
            this.spawnBerserkerSlamParticles();
        } else {
            super.handleEntityEvent(b);
        }
    }

    private void spawnBerserkerSlamParticles() {
        BlockPos pos = this.getOnPos();
        this.level().addParticle((ParticleOptions)GParticleTypes.BERSERKER_SLAM_SHOCKWAVE.get(), (double)pos.getX() + 0.5, (double)pos.getY() + 1.15, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        ParticleUtils.spawnSmashAttackParticles((LevelAccessor)this.level(), (BlockPos)pos, (int)120);
    }

    public Phase getPhase() {
        String s = (String)this.entityData.get(PHASE);
        return Phase.valueOf(s);
    }

    public void aiStep() {
        super.aiStep();
        double range = 0.75;
        double threshold = range - 0.6;
        double increment = 0.2;
        if (!this.level().isClientSide) {
            int count = 250;
            boolean stationary = this.isStationary();
            boolean shedding = this.isShedding();
            if (this.getHealth() < this.getMaxHealth() && this.tickCount % count == 0) {
                this.heal(10.0f);
            }
            if (stationary) {
                this.getBrain().getMemories().keySet().stream().filter(memoryModuleType -> memoryModuleType.equals(MemoryModuleType.WALK_TARGET) || memoryModuleType.equals(MemoryModuleType.LOOK_TARGET)).forEach(arg_0 -> this.getBrain().eraseMemory(arg_0));
                List<Player> list = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(3.0)).stream().filter(p -> !p.isCreative() && p.isAlive()).toList();
                Optional player = list.stream().findAny();
                if (!shedding) {
                    player.ifPresent(this::setTarget);
                } else {
                    list.stream().filter(ServerPlayer.class::isInstance).map(ServerPlayer.class::cast).forEach(serverPlayer -> CriteriaTriggers.SUMMONED_ENTITY.trigger(serverPlayer, (Entity)this));
                    if (this.getStationaryTicks() == 32) {
                        this.getBrain().setMemory(GMemoryModuleTypes.IS_SHAKING.get(), (Object)Unit.INSTANCE);
                    }
                    this.setStationaryTicks(this.getStationaryTicks() - 1);
                    this.addParticles(range, increment, threshold);
                }
            } else if (shedding) {
                this.setShedding(false);
                this.setPersistenceRequired();
            }
        }
    }

    private void addParticles(double range, double increment, double threshold) {
        if (this.tickCount % 20 == 0) {
            for (double y = 0.0; y <= 1.95; y += 0.35) {
                for (double x = -range; x <= range; x += increment) {
                    for (double z = -range; z <= range; z += increment) {
                        if (x >= -threshold && x <= threshold || z >= -threshold && z <= threshold) continue;
                        ((ServerLevel)this.level()).sendParticles((ParticleOptions)GParticleTypes.PINK_SALT_FALLING_DUST.get(), this.getX() + x, this.getY() + y, this.getZ() + z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public boolean isStationary() {
        return this.getStationaryTicks() > 0;
    }

    private void setTarget(Player player) {
        Brain<Berserker> brain = this.getBrain();
        brain.setMemory(MemoryModuleType.ATTACK_TARGET, (Object)player);
        this.setShedding(true);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (mobSpawnType == MobSpawnType.STRUCTURE) {
            this.setStationaryTicks(200);
        }
        this.getBrain().setMemoryWithExpiry(GMemoryModuleTypes.HALITE_ATTACK_COOLDOWN.get(), (Object)Unit.INSTANCE, 100L);
        return super.finalizeSpawn(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return this.isStationary() ? null : GSoundEvents.BERSERKER_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return GSoundEvents.BERSERKER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return GSoundEvents.BERSERKER_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return GSoundEvents.BERSERKER_STEP.get();
    }

    protected void playStepSound(BlockPos blockPos, BlockState blockState) {
        this.playSound(this.getStepSound(), 1.0f, 1.0f);
    }

    public boolean canTargetEntity(@Nullable Entity entity) {
        Entity e2;
        Entity entity2;
        HaliteCurse haliteCurse;
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (livingEntity instanceof HaliteCurse && (haliteCurse = (HaliteCurse)livingEntity).isHaliteCursed()) {
            return false;
        }
        Predicate<LivingEntity> predicate = e -> e.getType().is(GEntityTypeTags.BERSERKER_INVALID_TARGETS);
        if (livingEntity.isInvulnerable() || livingEntity.isDeadOrDying() || predicate.test(livingEntity)) {
            return false;
        }
        DamageSource lastSource = this.getLastDamageSource();
        if (lastSource != null && (entity2 = (e2 = lastSource.getEntity())) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity2;
            if (e2 == livingEntity && !predicate.test(living)) {
                return true;
            }
        }
        if (this.level() != entity.level() || !EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity) || this.isAlliedTo(entity) || !this.level().getWorldBorder().isWithinBounds(livingEntity.getBoundingBox())) {
            return false;
        }
        return livingEntity instanceof Player || livingEntity instanceof AbstractVillager || livingEntity instanceof IronGolem || livingEntity instanceof Turtle;
    }

    protected void updateWalkAnimation(float f) {
        float g = Math.min(f * 10.0f, 1.0f);
        this.walkAnimation.update(g, 0.2f);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> entityDataAccessor) {
        if (DATA_POSE.equals(entityDataAccessor) && this.getPose() == Pose.EMERGING) {
            this.roarAnimationState.start(this.tickCount);
        }
        super.onSyncedDataUpdated(entityDataAccessor);
    }

    public boolean shouldUseMeleeAttack() {
        Optional memory = this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        return memory.filter(livingEntity -> this.isWithinMeleeAttackRange((LivingEntity)livingEntity) && this.getPhase() != Phase.SMASH && this.shouldAttack() && this.isInHardMode() && this.getBrain().getMemory(GMemoryModuleTypes.RAMPAGE_TICKS.get()).isPresent() && (Integer)this.getBrain().getMemory(GMemoryModuleTypes.RAMPAGE_TICKS.get()).get() > 0).isPresent();
    }

    public boolean isInHardMode() {
        return this.level().getDifficulty() == Difficulty.HARD;
    }

    public boolean doHurtTarget(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity instanceof AbstractGolem || livingEntity instanceof TamableAnimal) {
                double dist = Math.max(1.0f, this.distanceTo((Entity)livingEntity));
                livingEntity.hurt(this.level().damageSources().mobAttack((LivingEntity)this), (float)((double)livingEntity.getMaxHealth() / (dist / 2.0)));
            }
            if (this.shouldUseMeleeAttack()) {
                Vec3 start = this.position().add(0.0, (double)1.6f, 0.0);
                Vec3 diff = entity.getEyePosition().subtract(start);
                Vec3 normalized = diff.normalize();
                double knockbackX = 0.25 * (1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                double knockbackY = 1.5 * (1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                livingEntity.push(normalized.x() * knockbackY, normalized.y() * knockbackX, normalized.z() * knockbackY);
                this.level().broadcastEntityEvent((Entity)this, (byte)5);
                this.playSound(GSoundEvents.BERSERKER_PUNCH.get(), 1.0f, 1.0f);
            }
        }
        return super.doHurtTarget(entity);
    }

    public boolean canDisableShield() {
        return true;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!this.level().isClientSide && this.getPhase() != Phase.IDLING && this.isInHardMode()) {
            if (this.getBrain().getMemory(GMemoryModuleTypes.HURT_COUNT.get()).isEmpty()) {
                this.getBrain().setMemory(GMemoryModuleTypes.HURT_COUNT.get(), (Object)0);
            } else {
                int i = (Integer)this.getBrain().getMemory(GMemoryModuleTypes.HURT_COUNT.get()).get() + 1;
                if (i > 2) {
                    i = 0;
                    this.getBrain().setMemory(GMemoryModuleTypes.RAMPAGE_TICKS.get(), (Object)UniformInt.of((int)30, (int)150).sample(this.getRandom()));
                }
                this.getBrain().setMemory(GMemoryModuleTypes.HURT_COUNT.get(), (Object)i);
            }
        }
        if (source.getDirectEntity() instanceof AbstractArrow && this.getPhase() != Phase.IDLING) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Berserker.createMonsterAttributes().add(Attributes.MAX_HEALTH, 155.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 1.5);
    }

    protected Brain.Provider<Berserker> brainProvider() {
        return Brain.provider(BerserkerAi.MEMORY_TYPES, BerserkerAi.SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return BerserkerAi.makeBrain(this, (Brain<Berserker>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Berserker> getBrain() {
        return super.getBrain();
    }

    protected void customServerAiStep() {
        ProfilerFiller profiler = this.level().getProfiler();
        profiler.push("berserkerBrain");
        Brain<Berserker> brain = this.getBrain();
        brain.tick((ServerLevel)this.level(), (LivingEntity)this);
        profiler.pop();
        profiler.push("berserkerActivityUpdate");
        BerserkerAi.updateActivity(this);
        profiler.pop();
        if (brain.getMemory(MemoryModuleType.HURT_BY_ENTITY).isEmpty() && this.getPhase() != Phase.IDLING) {
            this.setPhase(Phase.IDLING);
        }
        super.customServerAiStep();
    }

    public void travel(Vec3 vec3) {
        if (this.isStationary() && this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            vec3 = vec3.multiply(0.0, 1.0, 0.0);
        }
        super.travel(vec3);
    }

    public class BerserkerLookControl
    extends LookControl {
        public BerserkerLookControl(Mob mob) {
            super(mob);
        }

        public void tick() {
            if (!Berserker.this.isStationary()) {
                super.tick();
            }
        }
    }

    public static enum Phase {
        IDLING,
        SMASH,
        UNDERMINE,
        SUMMONING,
        HALITE_ATTACK;

    }
}

