/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.datagen;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.compat.init.ForgeItemTags;
import net.orcinus.galosphere.datagen.recipes.PreservedRecipeBuilder;
import net.orcinus.galosphere.init.GBlockFamilies;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GItems;

public class GRecipeProvider
extends RecipeProvider {
    private static final ImmutableList<ItemLike> PALLADIUM_SMELTABLES = ImmutableList.of((Object)((Block)GBlocks.PALLADIUM_ORE.get()).asItem(), (Object)((Block)GBlocks.DEEPSLATE_PALLADIUM_ORE.get()).asItem(), (Object)((ItemLike)GItems.RAW_PALLADIUM.get()));

    public GRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        GBlockFamilies.getAllFamilies().forEach(blockFamily -> GRecipeProvider.generateRecipes((RecipeOutput)recipeOutput, (BlockFamily)blockFamily, (FeatureFlagSet)FeatureFlags.VANILLA_SET));
        GRecipeProvider.trimSmithing((RecipeOutput)recipeOutput, (Item)((Item)GItems.FAITH_ARMOR_TRIM_SMITHING_TEMPLATE.get()), (ResourceLocation)Galosphere.id(GRecipeProvider.getItemName(GItems.FAITH_ARMOR_TRIM_SMITHING_TEMPLATE) + "_smithing_trim"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, GItems.ROPE_DART, (int)2).define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('A'), GItems.ALLURITE_SHARD).pattern("A").pattern("S").unlockedBy("has_allurite_shard", GRecipeProvider.has(GItems.ALLURITE_SHARD)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, GItems.ECHO_BELL).define(Character.valueOf('#'), GItems.BROKEN_ECHO_BELL).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('X'), GItems.ALLURITE_SHARD).define(Character.valueOf('C'), (ItemLike)Items.ECHO_SHARD).pattern(" # ").pattern("CXC").pattern(" S ").unlockedBy("has_echo_bell", GRecipeProvider.has(GItems.BROKEN_ECHO_BELL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, GItems.SALTBOUND_TABLET).define(Character.valueOf('S'), GItems.PINK_SALT_SHARD).define(Character.valueOf('@'), GItems.PRESERVED_FLESH).define(Character.valueOf('#'), GItems.PRESERVED_TEMPLATE).pattern("S@S").pattern("S#S").pattern("SSS").unlockedBy("has_preserved_template", GRecipeProvider.has(GItems.PRESERVED_TEMPLATE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, GItems.MONSTROMETER).define(Character.valueOf('P'), GItems.PALLADIUM_INGOT).define(Character.valueOf('L'), GItems.LUMIERE_SHARD).pattern(" P ").pattern("PLP").pattern(" P ").unlockedBy("has_lumiere_shard", GRecipeProvider.has(GItems.LUMIERE_SHARD)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GUNPOWDER).requires((ItemLike)Items.BONE_MEAL).requires((ItemLike)Items.COAL).requires((ItemLike)GItems.PINK_SALT_SHARD.get()).unlockedBy("has_pink_salt_shard", GRecipeProvider.has((ItemLike)((ItemLike)GItems.PINK_SALT_SHARD.get()))).save(recipeOutput, Galosphere.id("gunpowder_from_pink_salt_shard"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, GBlocks.TUFF_DIRT).define(Character.valueOf('#'), (ItemLike)Items.TUFF).define(Character.valueOf('C'), (ItemLike)Items.DIRT).pattern("#C").pattern("C#").unlockedBy("has_tuff", GRecipeProvider.has((ItemLike)Blocks.TUFF)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, GBlocks.BURROW_ANCHOR).define(Character.valueOf('#'), GItems.PALLADIUM_INGOT).define(Character.valueOf('S'), (ItemLike)Items.SCULK_SHRIEKER).define(Character.valueOf('X'), (ItemLike)Items.ECHO_SHARD).pattern(" # ").pattern("#S#").pattern(" X ").unlockedBy("has_echo_shard", GRecipeProvider.has((ItemLike)Items.ECHO_SHARD)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)GBlocks.PINK_SALT.get())).define(Character.valueOf('#'), (ItemLike)((Block)GBlocks.PINK_SALT_STRAW.get()).asItem()).pattern("##").pattern("##").unlockedBy("has_pink_salt_straw", GRecipeProvider.has((ItemLike)((ItemLike)GBlocks.PINK_SALT_STRAW.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)GBlocks.GILDED_BEADS.get()), (int)8).define(Character.valueOf('#'), (ItemLike)Items.GOLD_NUGGET).define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).pattern("GGG").pattern("###").pattern("GGG").unlockedBy("has_gold_ingot", GRecipeProvider.has((ItemLike)Items.GOLD_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)GBlocks.STRANDED_MEMBRANE_BLOCK.get())).define(Character.valueOf('#'), (ItemLike)GItems.ALLURITE_SHARD.get()).define(Character.valueOf('C'), (ItemLike)GBlocks.CURED_MEMBRANE_BLOCK.get()).pattern(" # ").pattern("#C#").pattern(" # ").unlockedBy("has_cured_membrane_block", GRecipeProvider.has((ItemLike)((ItemLike)GBlocks.CURED_MEMBRANE_BLOCK.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)GBlocks.SHADOW_FRAME.get()), (int)8).define(Character.valueOf('S'), ForgeItemTags.PALLADIUM_INGOT).define(Character.valueOf('#'), (ItemLike)GItems.CURED_MEMBRANE.get()).pattern("S#S").pattern("#S#").pattern("S#S").unlockedBy("has_cured_membrane", GRecipeProvider.has((ItemLike)((ItemLike)GItems.CURED_MEMBRANE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, GItems.WEAPON_RACK).define(Character.valueOf('#'), ForgeItemTags.PALLADIUM_INGOT).pattern("###").unlockedBy("has_palladium_ingot", GRecipeProvider.has((ItemLike)((ItemLike)GItems.PALLADIUM_INGOT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)GBlocks.PINK_SALT_LAMP.get())).define(Character.valueOf('#'), (ItemLike)GBlocks.PINK_SALT_CLUSTER.get()).define(Character.valueOf('S'), ForgeItemTags.PALLADIUM_INGOT).pattern("#").pattern("S").unlockedBy("has_pink_salt_cluster", GRecipeProvider.has((ItemLike)((ItemLike)GBlocks.PINK_SALT_CLUSTER.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)GItems.SALTED_JERKY.get())).define(Character.valueOf('S'), (ItemLike)GItems.PINK_SALT_SHARD.get()).define(Character.valueOf('#'), (ItemLike)Items.ROTTEN_FLESH).pattern(" S ").pattern("S#S").pattern(" S ").unlockedBy("has_pink_salt_shard", GRecipeProvider.has((ItemLike)((ItemLike)GItems.PINK_SALT_SHARD.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)GItems.CURED_MEMBRANE.get())).define(Character.valueOf('S'), (ItemLike)GItems.PINK_SALT_SHARD.get()).define(Character.valueOf('#'), (ItemLike)Items.PHANTOM_MEMBRANE).pattern(" S ").pattern("S#S").pattern(" S ").unlockedBy("has_pink_salt_shard", GRecipeProvider.has((ItemLike)((ItemLike)GItems.PINK_SALT_SHARD.get()))).save(recipeOutput);
        this.twoXtwo(recipeOutput, (ItemLike)GBlocks.CURED_MEMBRANE_BLOCK.get(), (ItemLike)GItems.CURED_MEMBRANE.get());
        this.twoXtwo(recipeOutput, (ItemLike)GBlocks.ALLURITE_BLOCK.get(), (Item)GItems.ALLURITE_SHARD.get(), 1);
        this.twoXtwo(recipeOutput, (ItemLike)GBlocks.LUMIERE_BLOCK.get(), (Item)GItems.LUMIERE_SHARD.get(), 1);
        this.threeXthree(recipeOutput, (ItemLike)GBlocks.PALLADIUM_BLOCK.get(), (Item)GItems.PALLADIUM_INGOT.get());
        this.threeXthree(recipeOutput, (ItemLike)GBlocks.RAW_PALLADIUM_BLOCK.get(), (Item)GItems.RAW_PALLADIUM.get());
        GRecipeProvider.nineBlockStorageRecipes((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)GItems.PALLADIUM_NUGGET.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)GItems.PALLADIUM_INGOT.get()), (String)Galosphere.id("palladium_ingot_from_nuggets").toString(), (String)"palladium_ingot", (String)Galosphere.id(GRecipeProvider.getSimpleRecipeName((ItemLike)((ItemLike)GItems.PALLADIUM_NUGGET.get()))).toString(), null);
        this.oreSmelting(recipeOutput, (List<ItemLike>)PALLADIUM_SMELTABLES, (ItemLike)GItems.PALLADIUM_INGOT.get(), 0.7f, 200, "palladium_ingot");
        this.oreBlasting(recipeOutput, (List<ItemLike>)PALLADIUM_SMELTABLES, (ItemLike)GItems.PALLADIUM_INGOT.get(), 0.7f, 100, "palladium_ingot");
        this.shaplessOne(recipeOutput, (Item)GItems.PALLADIUM_INGOT.get(), ((Block)GBlocks.PALLADIUM_BLOCK.get()).asItem(), 9);
        this.shaplessOne(recipeOutput, (Item)GItems.RAW_PALLADIUM.get(), ((Block)GBlocks.RAW_PALLADIUM_BLOCK.get()).asItem(), 9);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)GBlocks.PALLADIUM_LATTICE.get()), (int)16).define(Character.valueOf('#'), ForgeItemTags.PALLADIUM_INGOT).pattern("###").pattern("###").unlockedBy("has_palladium_ingot", GRecipeProvider.has((ItemLike)((ItemLike)GItems.PALLADIUM_INGOT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)GItems.GLOW_FLARE.get()), (int)4).define(Character.valueOf('#'), (ItemLike)Items.GLOW_INK_SAC).define(Character.valueOf('S'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('F'), (ItemLike)Items.STICK).pattern(" # ").pattern(" S ").pattern(" F ").unlockedBy("has_glow_ink_sac", GRecipeProvider.has((ItemLike)Items.GLOW_INK_SAC)).unlockedBy("has_copper_ingot", GRecipeProvider.has((TagKey)Tags.Items.INGOTS_COPPER)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, GBlocks.PALLADIUM_DUST, (int)4).requires(ForgeItemTags.PALLADIUM_NUGGETS).requires(Tags.Items.GUNPOWDERS).unlockedBy("has_palladium_ingot", GRecipeProvider.has(GItems.PALLADIUM_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, GItems.STERLING_HELMET).define(Character.valueOf('S'), GItems.PALLADIUM_INGOT).define(Character.valueOf('#'), (ItemLike)Items.LEATHER).pattern("#S#").pattern("S S").unlockedBy("has_palladium_ingot", GRecipeProvider.has(GItems.PALLADIUM_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, GItems.STERLING_CHESTPLATE).define(Character.valueOf('S'), GItems.PALLADIUM_INGOT).define(Character.valueOf('#'), (ItemLike)Items.LEATHER).pattern("S S").pattern("S#S").pattern("###").unlockedBy("has_palladium_ingot", GRecipeProvider.has(GItems.PALLADIUM_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, GItems.STERLING_LEGGINGS).define(Character.valueOf('S'), GItems.PALLADIUM_INGOT).define(Character.valueOf('#'), (ItemLike)Items.LEATHER).pattern("###").pattern("S S").pattern("S S").unlockedBy("has_palladium_ingot", GRecipeProvider.has(GItems.PALLADIUM_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, GItems.STERLING_BOOTS).define(Character.valueOf('S'), GItems.PALLADIUM_INGOT).define(Character.valueOf('#'), (ItemLike)Items.LEATHER).pattern("S S").pattern("# #").unlockedBy("has_palladium_ingot", GRecipeProvider.has(GItems.PALLADIUM_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)GItems.SPECTRE_FLARE.get())).define(Character.valueOf('#'), ForgeItemTags.PALLADIUM_INGOT).define(Character.valueOf('S'), (ItemLike)GItems.BOTTLE_OF_SPECTRE.get()).pattern("S").pattern("#").unlockedBy("has_palladium_ingot", GRecipeProvider.has(ForgeItemTags.PALLADIUM_INGOT)).unlockedBy("has_bottle_of_spectre", GRecipeProvider.has((ItemLike)((ItemLike)GItems.BOTTLE_OF_SPECTRE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)GItems.GOLDEN_LICHEN_CORDYCEPS.get())).define(Character.valueOf('#'), Tags.Items.NUGGETS_GOLD).define(Character.valueOf('@'), (ItemLike)GItems.LICHEN_CORDYCEPS.get()).pattern("###").pattern("#@#").pattern("###").unlockedBy("has_lichen_cordyceps", GRecipeProvider.has((ItemLike)((ItemLike)GItems.LICHEN_CORDYCEPS.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)GBlocks.CHANDELIER.get())).define(Character.valueOf('#'), ForgeItemTags.PALLADIUM_INGOT).define(Character.valueOf('S'), (ItemLike)Items.CHAIN).define(Character.valueOf('X'), Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL, Items.CHARCOAL})).pattern("SXS").pattern("###").unlockedBy("has_palladium_ingot", GRecipeProvider.has(ForgeItemTags.PALLADIUM_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)GBlocks.SOUL_CHANDELIER.get())).define(Character.valueOf('#'), ForgeItemTags.PALLADIUM_INGOT).define(Character.valueOf('S'), (ItemLike)Items.CHAIN).define(Character.valueOf('X'), ItemTags.SOUL_FIRE_BASE_BLOCKS).pattern("SXS").pattern("###").unlockedBy("has_palladium_ingot", GRecipeProvider.has(ForgeItemTags.PALLADIUM_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, GBlocks.LIGHT_STAND).define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL, Items.CHARCOAL})).define(Character.valueOf('X'), GItems.PALLADIUM_INGOT).pattern("#").pattern("X").pattern("X").unlockedBy("has_palladium_ingot", GRecipeProvider.has(ForgeItemTags.PALLADIUM_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, GBlocks.SOUL_LIGHT_STAND).define(Character.valueOf('#'), ItemTags.SOUL_FIRE_BASE_BLOCKS).define(Character.valueOf('X'), GItems.PALLADIUM_INGOT).pattern("#").pattern("X").pattern("X").unlockedBy("has_palladium_ingot", GRecipeProvider.has(ForgeItemTags.PALLADIUM_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)GBlocks.COMBUSTION_TABLE.get())).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('@'), ForgeItemTags.PALLADIUM_INGOT).pattern("@@").pattern("##").pattern("##").unlockedBy("has_palladium_ingot", GRecipeProvider.has(ForgeItemTags.PALLADIUM_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)GBlocks.AMETHYST_LAMP.get())).define(Character.valueOf('R'), (ItemLike)Items.AMETHYST_SHARD).define(Character.valueOf('G'), (ItemLike)Blocks.GLOWSTONE).pattern(" R ").pattern("RGR").pattern(" R ").unlockedBy("has_amethyst_shard", GRecipeProvider.has((ItemLike)Items.AMETHYST_SHARD)).unlockedBy("has_glowstone", GRecipeProvider.has((ItemLike)Blocks.GLOWSTONE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)GBlocks.ALLURITE_LAMP.get())).define(Character.valueOf('R'), (ItemLike)GItems.ALLURITE_SHARD.get()).define(Character.valueOf('G'), (ItemLike)Blocks.GLOWSTONE).pattern(" R ").pattern("RGR").pattern(" R ").unlockedBy("has_allurite_shard", GRecipeProvider.has((ItemLike)((ItemLike)GItems.ALLURITE_SHARD.get()))).unlockedBy("has_glowstone", GRecipeProvider.has((ItemLike)Blocks.GLOWSTONE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)GBlocks.LUMIERE_LAMP.get())).define(Character.valueOf('R'), (ItemLike)GItems.LUMIERE_SHARD.get()).define(Character.valueOf('G'), (ItemLike)Blocks.GLOWSTONE).pattern(" R ").pattern("RGR").pattern(" R ").unlockedBy("has_lumiere_shard", GRecipeProvider.has((ItemLike)((ItemLike)GItems.LUMIERE_SHARD.get()))).unlockedBy("has_glowstone", GRecipeProvider.has((ItemLike)Blocks.GLOWSTONE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)GItems.PALLADIUM_BOMB.get()), (int)2).define(Character.valueOf('R'), ForgeItemTags.PALLADIUM_INGOT).define(Character.valueOf('G'), (ItemLike)Items.GUNPOWDER).pattern(" R ").pattern("RGR").pattern(" R ").unlockedBy("has_gunpowder", GRecipeProvider.has((ItemLike)Items.GUNPOWDER)).save(recipeOutput);
        GRecipeProvider.nineBlockStorageRecipes((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.MISC, GItems.OPAL, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, GBlocks.OPAL_BLOCK, (String)Galosphere.id(GRecipeProvider.getSimpleRecipeName(GBlocks.OPAL_BLOCK)).toString(), null, (String)Galosphere.id("opal_from_opal_block").toString(), (String)"opal");
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PINK_SALT_STAIRS.get(), (ItemLike)GBlocks.PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PINK_SALT_SLAB.get(), (ItemLike)GBlocks.PINK_SALT.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PINK_SALT_WALL.get(), (ItemLike)GBlocks.PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_PINK_SALT.get(), (ItemLike)GBlocks.PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_PINK_SALT_STAIRS.get(), (ItemLike)GBlocks.PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_PINK_SALT_SLAB.get(), (ItemLike)GBlocks.PINK_SALT.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_PINK_SALT_WALL.get(), (ItemLike)GBlocks.PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PINK_SALT_BRICKS.get(), (ItemLike)GBlocks.PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PINK_SALT_BRICK_STAIRS.get(), (ItemLike)GBlocks.PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PINK_SALT_BRICK_SLAB.get(), (ItemLike)GBlocks.PINK_SALT.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PINK_SALT_BRICK_WALL.get(), (ItemLike)GBlocks.PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.CHISELED_PINK_SALT.get(), (ItemLike)GBlocks.PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_PINK_SALT_STAIRS.get(), (ItemLike)GBlocks.POLISHED_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_PINK_SALT_SLAB.get(), (ItemLike)GBlocks.POLISHED_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_PINK_SALT_WALL.get(), (ItemLike)GBlocks.POLISHED_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PINK_SALT_BRICKS.get(), (ItemLike)GBlocks.POLISHED_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PINK_SALT_BRICK_STAIRS.get(), (ItemLike)GBlocks.POLISHED_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PINK_SALT_BRICK_SLAB.get(), (ItemLike)GBlocks.POLISHED_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PINK_SALT_BRICK_WALL.get(), (ItemLike)GBlocks.POLISHED_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PINK_SALT_BRICKS.get(), (ItemLike)GBlocks.PINK_SALT_BRICKS.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PINK_SALT_BRICK_STAIRS.get(), (ItemLike)GBlocks.PINK_SALT_BRICKS.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PINK_SALT_BRICK_SLAB.get(), (ItemLike)GBlocks.PINK_SALT_BRICKS.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PINK_SALT_BRICK_WALL.get(), (ItemLike)GBlocks.PINK_SALT_BRICKS.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ROSE_PINK_SALT_STAIRS.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ROSE_PINK_SALT_SLAB.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ROSE_PINK_SALT_WALL.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT_STAIRS.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT_SLAB.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT_WALL.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ROSE_PINK_SALT_BRICKS.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ROSE_PINK_SALT_BRICK_STAIRS.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ROSE_PINK_SALT_BRICK_SLAB.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ROSE_PINK_SALT_BRICK_WALL.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.CHISELED_ROSE_PINK_SALT.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT_STAIRS.get(), (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT_SLAB.get(), (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT_WALL.get(), (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ROSE_PINK_SALT_BRICKS.get(), (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ROSE_PINK_SALT_BRICK_STAIRS.get(), (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ROSE_PINK_SALT_BRICK_SLAB.get(), (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ROSE_PINK_SALT_BRICK_WALL.get(), (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ROSE_PINK_SALT_BRICKS.get(), (ItemLike)GBlocks.ROSE_PINK_SALT_BRICKS.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ROSE_PINK_SALT_BRICK_STAIRS.get(), (ItemLike)GBlocks.ROSE_PINK_SALT_BRICKS.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ROSE_PINK_SALT_BRICK_SLAB.get(), (ItemLike)GBlocks.ROSE_PINK_SALT_BRICKS.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ROSE_PINK_SALT_BRICK_WALL.get(), (ItemLike)GBlocks.ROSE_PINK_SALT_BRICKS.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PASTEL_PINK_SALT_STAIRS.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PASTEL_PINK_SALT_SLAB.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PASTEL_PINK_SALT_WALL.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT_STAIRS.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT_SLAB.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT_WALL.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICKS.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICK_STAIRS.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICK_SLAB.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICK_WALL.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.CHISELED_PASTEL_PINK_SALT.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT_STAIRS.get(), (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT_SLAB.get(), (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT_WALL.get(), (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICKS.get(), (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICK_STAIRS.get(), (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICK_SLAB.get(), (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICK_WALL.get(), (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICKS.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICKS.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICK_STAIRS.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICKS.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICK_SLAB.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICKS.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICK_WALL.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICKS.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.SMOOTH_AMETHYST.get(), (ItemLike)Blocks.AMETHYST_BLOCK);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.SMOOTH_ALLURITE.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.SMOOTH_LUMIERE.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.AMETHYST_SLAB.get(), (ItemLike)Blocks.AMETHYST_BLOCK, 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ALLURITE_SLAB.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.LUMIERE_SLAB.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.AMETHYST_STAIRS.get(), (ItemLike)Blocks.AMETHYST_BLOCK);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ALLURITE_STAIRS.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.LUMIERE_STAIRS.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.SMOOTH_AMETHYST_SLAB.get(), (ItemLike)Blocks.AMETHYST_BLOCK, 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.SMOOTH_ALLURITE_SLAB.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.SMOOTH_LUMIERE_SLAB.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.SMOOTH_AMETHYST_SLAB.get(), (ItemLike)GBlocks.SMOOTH_AMETHYST.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.SMOOTH_ALLURITE_SLAB.get(), (ItemLike)GBlocks.SMOOTH_ALLURITE.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.SMOOTH_LUMIERE_SLAB.get(), (ItemLike)GBlocks.SMOOTH_LUMIERE.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.AMETHYST_BRICK_SLAB.get(), (ItemLike)Blocks.AMETHYST_BLOCK, 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ALLURITE_BRICK_SLAB.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.LUMIERE_BRICK_SLAB.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.AMETHYST_BRICK_SLAB.get(), (ItemLike)GBlocks.SMOOTH_AMETHYST.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ALLURITE_BRICK_SLAB.get(), (ItemLike)GBlocks.SMOOTH_ALLURITE.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.LUMIERE_BRICK_SLAB.get(), (ItemLike)GBlocks.SMOOTH_LUMIERE.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.AMETHYST_BRICK_SLAB.get(), (ItemLike)GBlocks.AMETHYST_BRICKS.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ALLURITE_BRICK_SLAB.get(), (ItemLike)GBlocks.ALLURITE_BRICKS.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.LUMIERE_BRICK_SLAB.get(), (ItemLike)GBlocks.LUMIERE_BRICKS.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.AMETHYST_BRICK_STAIRS.get(), (ItemLike)Blocks.AMETHYST_BLOCK);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ALLURITE_BRICK_STAIRS.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.LUMIERE_BRICK_STAIRS.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.AMETHYST_BRICK_STAIRS.get(), (ItemLike)GBlocks.SMOOTH_AMETHYST.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ALLURITE_BRICK_STAIRS.get(), (ItemLike)GBlocks.SMOOTH_ALLURITE.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.LUMIERE_BRICK_STAIRS.get(), (ItemLike)GBlocks.SMOOTH_LUMIERE.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.AMETHYST_BRICK_STAIRS.get(), (ItemLike)GBlocks.AMETHYST_BRICKS.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ALLURITE_BRICK_STAIRS.get(), (ItemLike)GBlocks.ALLURITE_BRICKS.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.LUMIERE_BRICK_STAIRS.get(), (ItemLike)GBlocks.LUMIERE_BRICKS.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.SMOOTH_AMETHYST_STAIRS.get(), (ItemLike)Blocks.AMETHYST_BLOCK);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.SMOOTH_ALLURITE_STAIRS.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.SMOOTH_LUMIERE_STAIRS.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.SMOOTH_AMETHYST_STAIRS.get(), (ItemLike)GBlocks.SMOOTH_AMETHYST.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.SMOOTH_ALLURITE_STAIRS.get(), (ItemLike)GBlocks.SMOOTH_ALLURITE.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.SMOOTH_LUMIERE_STAIRS.get(), (ItemLike)GBlocks.SMOOTH_LUMIERE.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.CHISELED_AMETHYST.get(), (ItemLike)Blocks.AMETHYST_BLOCK);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.CHISELED_ALLURITE.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.CHISELED_LUMIERE.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.CHISELED_AMETHYST.get(), (ItemLike)GBlocks.SMOOTH_AMETHYST.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.CHISELED_ALLURITE.get(), (ItemLike)GBlocks.SMOOTH_ALLURITE.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.CHISELED_LUMIERE.get(), (ItemLike)GBlocks.SMOOTH_LUMIERE.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.CHISELED_AMETHYST.get(), (ItemLike)GBlocks.AMETHYST_BRICKS.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.CHISELED_ALLURITE.get(), (ItemLike)GBlocks.ALLURITE_BRICKS.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.CHISELED_LUMIERE.get(), (ItemLike)GBlocks.LUMIERE_BRICKS.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.AMETHYST_BRICKS.get(), (ItemLike)Blocks.AMETHYST_BLOCK);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ALLURITE_BRICKS.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.LUMIERE_BRICKS.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.AMETHYST_BRICKS.get(), (ItemLike)GBlocks.SMOOTH_AMETHYST.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.ALLURITE_BRICKS.get(), (ItemLike)GBlocks.SMOOTH_ALLURITE.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.LUMIERE_BRICKS.get(), (ItemLike)GBlocks.SMOOTH_LUMIERE.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PALLADIUM_PANEL.get(), (ItemLike)GBlocks.PALLADIUM_BLOCK.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PALLADIUM_PANEL_STAIRS.get(), (ItemLike)GBlocks.PALLADIUM_BLOCK.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PALLADIUM_PANEL_SLAB.get(), (ItemLike)GBlocks.PALLADIUM_BLOCK.get(), 4);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PALLADIUM_TILES.get(), (ItemLike)GBlocks.PALLADIUM_BLOCK.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PALLADIUM_TILES_STAIRS.get(), (ItemLike)GBlocks.PALLADIUM_BLOCK.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PALLADIUM_TILES_SLAB.get(), (ItemLike)GBlocks.PALLADIUM_BLOCK.get(), 4);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PALLADIUM_PANEL_STAIRS.get(), (ItemLike)GBlocks.PALLADIUM_PANEL.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PALLADIUM_PANEL_SLAB.get(), (ItemLike)GBlocks.PALLADIUM_PANEL.get(), 4);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PALLADIUM_TILES.get(), (ItemLike)GBlocks.PALLADIUM_PANEL.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PALLADIUM_TILES_STAIRS.get(), (ItemLike)GBlocks.PALLADIUM_PANEL.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PALLADIUM_TILES_SLAB.get(), (ItemLike)GBlocks.PALLADIUM_PANEL.get(), 4);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PALLADIUM_TILES_STAIRS.get(), (ItemLike)GBlocks.PALLADIUM_TILES.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.PALLADIUM_TILES_SLAB.get(), (ItemLike)GBlocks.PALLADIUM_TILES.get(), 4);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.OPAL_BRICKS.get(), (ItemLike)GBlocks.OPAL_BLOCK.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.OPAL_BRICK_STAIRS.get(), (ItemLike)GBlocks.OPAL_BLOCK.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.OPAL_BRICK_SLAB.get(), (ItemLike)GBlocks.OPAL_BLOCK.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.OPAL_BRICK_WALL.get(), (ItemLike)GBlocks.OPAL_BLOCK.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.CHISELED_OPAL_BRICKS.get(), (ItemLike)GBlocks.OPAL_BLOCK.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.OPAL_BRICK_STAIRS.get(), (ItemLike)GBlocks.OPAL_BRICKS.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.OPAL_BRICK_SLAB.get(), (ItemLike)GBlocks.OPAL_BRICKS.get(), 2);
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.OPAL_BRICK_WALL.get(), (ItemLike)GBlocks.OPAL_BRICKS.get());
        this.stonecutterResultFromBase(recipeOutput, (ItemLike)GBlocks.CHISELED_OPAL_BRICKS.get(), (ItemLike)GBlocks.OPAL_BRICKS.get());
        PreservedRecipeBuilder.create(Ingredient.of((ItemLike[])new ItemLike[]{GItems.PRESERVED_TEMPLATE}), Ingredient.of(GItemTags.PRESERVABLE_ITEMS), Ingredient.of((ItemLike[])new ItemLike[]{GItems.PINK_SALT_SHARD})).unlocks("has_smithing_trim_template", GRecipeProvider.has(GItems.PRESERVED_TEMPLATE)).save(recipeOutput, Galosphere.id("preserved_transform_recipe"));
    }

    protected void stonecutterResultFromBase(RecipeOutput recipeOutput, ItemLike result, ItemLike ingredient) {
        this.stonecutterResultFromBase(recipeOutput, result, ingredient, 1);
    }

    protected void stonecutterResultFromBase(RecipeOutput recipeOutput, ItemLike result, ItemLike ingredient, int count) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).unlockedBy(GRecipeProvider.getHasName(ingredient), GRecipeProvider.has((ItemLike)ingredient)).save(recipeOutput, Galosphere.id(GRecipeProvider.getConversionRecipeName(result, ingredient) + "_stonecutting"));
    }

    protected static String getConversionRecipeName(ItemLike result, ItemLike ingredient) {
        return GRecipeProvider.getItemName(result) + "_from_" + GRecipeProvider.getItemName(ingredient);
    }

    private void shaplessOne(RecipeOutput recipeOutput, Item result, Item item, int count) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)count).requires((ItemLike)item).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)item).getPath(), GRecipeProvider.has((ItemLike)item)).save(recipeOutput);
    }

    private void twoXtwo(RecipeOutput recipeOutput, ItemLike result, ItemLike item) {
        this.twoXtwo(recipeOutput, result, item.asItem(), 4);
    }

    private void twoXtwo(RecipeOutput recipeOutput, ItemLike result, Item item, int count) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).define(Character.valueOf('S'), (ItemLike)item).pattern("SS").pattern("SS").unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)item).getPath(), GRecipeProvider.has((ItemLike)item)).save(recipeOutput);
    }

    private void threeXthree(RecipeOutput recipeOutput, ItemLike result, Item item) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('S'), (ItemLike)item).pattern("SSS").pattern("SSS").pattern("SSS").unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)item).getPath(), GRecipeProvider.has((ItemLike)item)).save(recipeOutput);
    }

    protected void oreSmelting(RecipeOutput recipeOutput, List<ItemLike> items, ItemLike p_176594_, float p_176595_, int p_176596_, String p_176597_) {
        this.oreCooking(recipeOutput, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, items, p_176594_, p_176595_, p_176596_, p_176597_, "_from_smelting");
    }

    protected void oreBlasting(RecipeOutput recipeOutput, List<ItemLike> items, ItemLike p_176628_, float p_176629_, int p_176630_, String p_176631_) {
        this.oreCooking(recipeOutput, RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, items, p_176628_, p_176629_, p_176630_, p_176631_, "_from_blasting");
    }

    protected <T extends AbstractCookingRecipe> void oreCooking(RecipeOutput recipeOutput, RecipeSerializer<T> serializer, AbstractCookingRecipe.Factory<T> factory, List<ItemLike> itemLike, ItemLike item, float experience, int time, String group, String name) {
        for (ItemLike itemlike : itemLike) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (float)experience, (int)time, serializer, factory).group(group).unlockedBy(GRecipeProvider.getHasName(itemlike), GRecipeProvider.has((ItemLike)itemlike)).save(recipeOutput, Galosphere.id(GRecipeProvider.getItemName(item) + name + "_" + GRecipeProvider.getItemName(itemlike)));
        }
    }

    protected static String getHasName(ItemLike p_176603_) {
        return "has_" + GRecipeProvider.getItemName(p_176603_);
    }

    protected static String getItemName(ItemLike item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath();
    }
}

