/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.init.GMobEffects;

@OnlyIn(value=Dist.CLIENT)
public class SaltStatueLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation SALT_TEXTURE = Galosphere.id("textures/block/pink_salt.png");

    public SaltStatueLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag = livingEntity.hasEffect(GMobEffects.HALITE_CURSE);
        if (flag) {
            SheetedDecalTextureGenerator vertexConsumer = new SheetedDecalTextureGenerator(bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)SALT_TEXTURE)), poseStack.last(), 1.0f);
            this.getParentModel().renderToBuffer(poseStack, (VertexConsumer)vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, 0);
        }
    }
}

