/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.client.model.PinkSaltPillarModel;
import net.orcinus.galosphere.entities.PinkSaltPillar;
import net.orcinus.galosphere.init.GModelLayers;

@OnlyIn(value=Dist.CLIENT)
public class PinkSaltPillarRenderer
extends EntityRenderer<PinkSaltPillar> {
    private static final ResourceLocation TEXTURE = Galosphere.id("textures/entity/pink_salt_pillar/pink_salt_pillar.png");
    private final PinkSaltPillarModel model;

    public PinkSaltPillarRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new PinkSaltPillarModel(context.bakeLayer(GModelLayers.PINK_SALT_PILLAR));
    }

    public void render(PinkSaltPillar entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (!entity.isActive()) {
            return;
        }
        float ticks = (float)entity.tickCount + partialTick;
        poseStack.pushPose();
        poseStack.scale(1.0f, -1.0f, 1.0f);
        poseStack.translate(0.0f, -1.0f, 0.0f);
        this.model.setupAnim(entity, 0.0f, 0.0f, ticks, entity.getYRot(), entity.getXRot());
        VertexConsumer vertexConsumer = bufferSource.getBuffer(this.model.renderType(TEXTURE));
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(PinkSaltPillar entity) {
        return TEXTURE;
    }
}

