/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.blocks.blockentities.EchoAltarBlockEntity;

@OnlyIn(value=Dist.CLIENT)
public class EchoAltarRenderer
implements BlockEntityRenderer<EchoAltarBlockEntity> {
    private final ItemRenderer itemRenderer;

    public EchoAltarRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(EchoAltarBlockEntity blockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        ItemStack stack = blockEntity.getItem(0);
        int k = (int)blockEntity.getBlockPos().asLong();
        if (!blockEntity.isEmpty() && !stack.isEmpty()) {
            float h;
            for (h = blockEntity.rot - blockEntity.oRot; h >= (float)Math.PI; h -= (float)Math.PI * 2) {
            }
            while (h < (float)(-Math.PI)) {
                h += (float)Math.PI * 2;
            }
            float rot = blockEntity.oRot + h * f;
            poseStack.pushPose();
            poseStack.translate(0.5f, 1.3f, 0.5f);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.mulPose(Axis.YP.rotation(-rot));
            this.itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, i, OverlayTexture.NO_OVERLAY, poseStack, multiBufferSource, blockEntity.getLevel(), k);
            poseStack.popPose();
        }
    }
}

