/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.items.MonstrometerItem;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class IndicatorParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private static final Vector3f SAFE_COLOR = Vec3.fromRGB24((int)16757273).toVector3f();
    private static final Vector3f UNSAFE_COLOR = Vec3.fromRGB24((int)9681407).toVector3f();

    public IndicatorParticle(ClientLevel world, double x, double y, double z, double pQuadSizeMulitiplier, SpriteSet sprites) {
        super(world, x, y, z);
        this.alpha = 1.0f;
        this.quadSize = 0.0f;
        this.lifetime = 48;
        this.rCol = this.getColor().x();
        this.gCol = this.getColor().y();
        this.bCol = this.getColor().z();
        this.sprites = sprites;
        this.setSpriteFromAge(this.sprites);
    }

    private Vector3f getColor() {
        return MonstrometerItem.isUnsafe((Level)this.level, BlockPos.containing((double)this.x, (double)this.y, (double)this.z)) ? UNSAFE_COLOR : SAFE_COLOR;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.quadSize = Mth.lerp((float)0.06f, (float)this.quadSize, (float)0.5f);
        this.rCol = Mth.lerp((float)0.25f, (float)this.rCol, (float)this.getColor().x());
        this.gCol = Mth.lerp((float)0.25f, (float)this.gCol, (float)this.getColor().y());
        this.bCol = Mth.lerp((float)0.25f, (float)this.bCol, (float)this.getColor().z());
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else if (this.age > this.lifetime / 2) {
            this.alpha -= 0.04f;
        }
        this.setSpriteFromAge(this.sprites);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void render(VertexConsumer consumer, Camera camera, float delta) {
        this.renderRotatedQuad(consumer, camera, Axis.XP.rotation(1.5707964f), delta);
        this.renderRotatedQuad(consumer, camera, Axis.XN.rotation(1.5707964f), delta);
    }

    protected int getLightColor(float tint) {
        return Math.max(50, super.getLightColor(tint));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double speed, double pYSpeed, double pZSpeed) {
            return new IndicatorParticle(pLevel, pX, pY, pZ, speed, this.sprites);
        }
    }
}

