/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CrystalRainParticle
extends SimpleAnimatedParticle {
    public CrystalRainParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet set) {
        super(world, x, y, z, set, 0.0125f);
        this.xd = velocityX;
        this.yd = velocityY;
        this.zd = velocityZ;
        this.quadSize *= 2.0f;
        this.lifetime = 60 + this.random.nextInt(12);
        this.setSpriteFromAge(set);
    }

    public void move(double x, double y, double z) {
        this.setBoundingBox(this.getBoundingBox().move(x, y, z));
        this.setLocationFromBoundingbox();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType p_106566_, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new CrystalRainParticle(world, x, y, z, velocityX, velocityY, velocityZ, this.sprites);
        }
    }
}

