/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.client.animations.SpecterpillarAnimations;
import net.orcinus.galosphere.entities.Specterpillar;

@OnlyIn(value=Dist.CLIENT)
public class SpecterpillarModel
extends HierarchicalModel<Specterpillar> {
    private final ModelPart root;
    private final ModelPart body;

    public SpecterpillarModel(ModelPart root) {
        this.root = root;
        this.body = root.getChild("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -1.5f, -4.5f, 5.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)16);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(Specterpillar entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(entity.burrowAnimationState, SpecterpillarAnimations.SPECTERPILLAR_BURROW, ageInTicks);
        this.body.zScale = 1.0f + Mth.sin((float)(ageInTicks * 0.2f + limbSwing / 600.0f)) * (0.07f + limbSwingAmount / 3.0f);
    }
}

