/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.client.animations.BerserkerAnimations;
import net.orcinus.galosphere.entities.Berserker;

@OnlyIn(value=Dist.CLIENT)
public class BerserkerModel
extends HierarchicalModel<Berserker> {
    private final ModelPart root;

    public BerserkerModel(ModelPart root) {
        this.root = root.getChild("root");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition rightLeg = root.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(62, 0).addBox(-4.0f, -2.5f, -2.0f, 8.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)-12.5f, (float)11.0f));
        PartDefinition leftLeg = root.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(58, 62).addBox(-4.0f, -2.5f, -2.0f, 8.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)-12.5f, (float)11.0f));
        PartDefinition rightArm = root.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(0, 36).addBox(-4.0f, -3.5f, -4.0f, 8.0f, 24.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(32, 75).addBox(-4.0f, -5.5f, -4.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-10.0f, (float)-20.5f, (float)-8.0f));
        PartDefinition leftArm = root.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(32, 36).addBox(-4.0f, -3.5f, -4.0f, 8.0f, 24.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(78, 75).addBox(-4.0f, -5.5f, -4.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)10.0f, (float)-20.5f, (float)-8.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-10.0f, -5.75f, -18.5f, 20.0f, 14.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-17.25f, (float)9.5f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition firstSpike = body.addOrReplaceChild("firstSpike", CubeListBuilder.create().texOffs(64, 36).addBox(-3.0f, -17.0f, -3.5f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.75f, (float)-13.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition secondSpike = body.addOrReplaceChild("secondSpike", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -15.0f, -1.5f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.75f, (float)-6.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition thirdSpike = body.addOrReplaceChild("thirdSpike", CubeListBuilder.create().texOffs(90, 0).addBox(-1.0f, -12.0f, -1.5f, 2.0f, 13.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.75f, (float)0.5f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(24, 68).addBox(-4.0f, 3.0f, -6.0f, 8.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 68).addBox(-4.0f, -5.0f, -6.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-25.0f, (float)-9.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)112, (int)96);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(Berserker entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        ModelPart head = this.root.getChild("head");
        head.xRot = headPitch * ((float)Math.PI / 180);
        head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.animateWalk(BerserkerAnimations.BERSERKER_WALK, limbSwing, limbSwingAmount, 3.0f, 4.5f);
        this.animate(entity.attackAnimationState, BerserkerAnimations.BERSERKER_ATTACK, ageInTicks, 1.0f);
        this.animate(entity.impalingAnimationState, BerserkerAnimations.BERSERKER_IMPALING, ageInTicks, 1.0f);
        this.animate(entity.roarAnimationState, BerserkerAnimations.BERSERKER_SHAKE, ageInTicks, 1.0f);
        this.animate(entity.punchAnimationState, BerserkerAnimations.BERSERKER_PUNCH, ageInTicks, 1.0f);
        this.animate(entity.summoningAnimationState, BerserkerAnimations.BERSERKER_SPAWN_MINIONS, ageInTicks, 1.0f);
        this.animate(entity.salifyingAnimationState, BerserkerAnimations.BERSERKER_HALITE_ATTACK, ageInTicks, 1.0f);
    }
}

