/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.orcinus.galosphere.blocks.blockentities.EchoAltarBlockEntity;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import org.jetbrains.annotations.Nullable;

public class EchoAltarBlock
extends BaseEntityBlock {
    public static final MapCodec<EchoAltarBlock> CODEC = EchoAltarBlock.simpleCodec(EchoAltarBlock::new);
    public static final BooleanProperty BLOOM = BlockStateProperties.BLOOM;

    public EchoAltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BLOOM, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BLOOM});
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        EchoAltarBlockEntity entity;
        block11: {
            block10: {
                BlockEntity blockEntity = level.getBlockEntity(blockPos);
                if (!(blockEntity instanceof EchoAltarBlockEntity)) break block10;
                entity = (EchoAltarBlockEntity)blockEntity;
                if (!((Boolean)blockState.getValue((Property)BLOOM)).booleanValue()) break block11;
            }
            return ItemInteractionResult.FAIL;
        }
        if (entity.isEmpty()) {
            if (!itemStack.isEmpty() && itemStack.getCount() == 1 && itemStack.has(DataComponents.ENCHANTMENTS)) {
                entity.setItem(0, itemStack.consumeAndReturn(1, (LivingEntity)player));
                level.playSound(null, blockPos, SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
        } else {
            ItemStack storedItem = entity.getItem(0);
            ItemEnchantments itemEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)storedItem);
            Optional<Holder> cursed = itemEnchantments.keySet().stream().filter(enchantmentHolder -> enchantmentHolder.is(EnchantmentTags.CURSE)).findAny();
            if (itemStack.is(Items.ECHO_SHARD) && cursed.isPresent()) {
                itemStack.consume(1, (LivingEntity)player);
                level.playSound(null, blockPos, SoundEvents.END_PORTAL_SPAWN, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.setBlock(blockPos, (BlockState)blockState.setValue((Property)BLOOM, (Comparable)Boolean.valueOf(true)), 3);
                return ItemInteractionResult.SUCCESS;
            }
            if (itemStack.isEmpty()) {
                storedItem = entity.removeItem(0, 1);
                if (!player.getInventory().add(storedItem)) {
                    player.drop(storedItem, false);
                }
                System.out.println(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)storedItem));
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? EchoAltarBlock.createTickerHelper(blockEntityType, GBlockEntityTypes.ECHO_ALTAR.get(), EchoAltarBlockEntity::clientTick) : EchoAltarBlock.createTickerHelper(blockEntityType, GBlockEntityTypes.ECHO_ALTAR.get(), EchoAltarBlockEntity::serverTick);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new EchoAltarBlockEntity(blockPos, blockState);
    }

    protected RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }
}

