/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.utils;

import com.mojang.datafixers.util.Pair;
import io.redspace.ironsjewelry.IronsJewelry;
import io.redspace.ironsjewelry.ServerConfig;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

@EventBusSubscriber
public class VillageAddition {
    private static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceKey<StructureProcessorList> proccessor, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        Holder.Reference processor = processorListRegistry.getHolderOrThrow(proccessor);
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.get(poolRL);
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.legacy((String)IronsJewelry.id(nbtPieceRL).toString(), (Holder)processor).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.templates.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.rawTemplates);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.rawTemplates = listOfPieceEntries;
    }

    @SubscribeEvent
    public static void addNewVillageBuilding(ServerAboutToStartEvent event) {
        Registry templatePoolRegistry = (Registry)event.getServer().registryAccess().registry(Registries.TEMPLATE_POOL).orElseThrow();
        Registry processorListRegistry = (Registry)event.getServer().registryAccess().registry(Registries.PROCESSOR_LIST).orElseThrow();
        int weight = (Integer)ServerConfig.JEWELER_HOUSE_WEIGHT.get();
        VillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, (ResourceKey<StructureProcessorList>)ProcessorLists.MOSSIFY_70_PERCENT, ResourceLocation.parse((String)"minecraft:village/plains/houses"), "village/plains/house_jeweler", weight);
        VillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, (ResourceKey<StructureProcessorList>)ProcessorLists.MOSSIFY_70_PERCENT, ResourceLocation.parse((String)"minecraft:village/desert/houses"), "village/desert/house_jeweler", weight);
        VillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, (ResourceKey<StructureProcessorList>)ProcessorLists.MOSSIFY_70_PERCENT, ResourceLocation.parse((String)"minecraft:village/taiga/houses"), "village/taiga/house_jeweler", weight);
        VillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, (ResourceKey<StructureProcessorList>)ProcessorLists.MOSSIFY_70_PERCENT, ResourceLocation.parse((String)"minecraft:village/savanna/houses"), "village/savanna/house_jeweler", weight);
        VillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, (ResourceKey<StructureProcessorList>)ProcessorLists.MOSSIFY_70_PERCENT, ResourceLocation.parse((String)"minecraft:village/snowy/houses"), "village/snowy/house_jeweler", weight);
    }
}

