/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.core.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsjewelry.core.MaterialModifierDataHandler;
import io.redspace.ironsjewelry.core.bonuses.BonusType;
import io.redspace.ironsjewelry.core.data.Bonus;
import io.redspace.ironsjewelry.core.data.BonusInstance;
import io.redspace.ironsjewelry.core.data.MaterialDefinition;
import io.redspace.ironsjewelry.core.data.PartDefinition;
import io.redspace.ironsjewelry.core.data.PartIngredient;
import io.redspace.ironsjewelry.core.data.PatternDefinition;
import io.redspace.ironsjewelry.core.data.QualityScalar;
import io.redspace.ironsjewelry.core.parameters.IBonusParameterType;
import io.redspace.ironsjewelry.registry.ComponentRegistry;
import io.redspace.ironsjewelry.registry.IronsJewelryRegistries;
import io.redspace.ironsjewelry.registry.ParameterTypeRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class JewelryData {
    public static final Codec<JewelryData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)IronsJewelryRegistries.Codecs.PATTERN_REGISTRY_CODEC.fieldOf("pattern").forGetter(JewelryData::pattern), (App)Codec.unboundedMap(IronsJewelryRegistries.Codecs.PART_REGISTRY_CODEC, IronsJewelryRegistries.Codecs.MATERIAL_REGISTRY_CODEC).fieldOf("parts").forGetter(JewelryData::parts)).apply((Applicative)builder, JewelryData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, JewelryData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry(IronsJewelryRegistries.Keys.PATTERN_REGISTRY_KEY), jewelryData -> jewelryData.pattern, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.holderRegistry(IronsJewelryRegistries.Keys.PART_REGISTRY_KEY), (StreamCodec)ByteBufCodecs.holderRegistry(IronsJewelryRegistries.Keys.MATERIAL_REGISTRY_KEY)), jewelryData -> jewelryData.parts, JewelryData::new);
    private final Holder<PatternDefinition> pattern;
    private final Map<Holder<PartDefinition>, Holder<MaterialDefinition>> parts;
    private final boolean valid;
    private final List<BonusInstance> bonuses;
    private final int hashCode;
    public static JewelryData NONE = new JewelryData();

    public JewelryData(Holder<PatternDefinition> pattern, Map<Holder<PartDefinition>, Holder<MaterialDefinition>> parts) {
        this.pattern = pattern;
        this.parts = parts;
        this.valid = this.validate();
        this.bonuses = this.cacheBonuses();
        AtomicInteger i = new AtomicInteger(1);
        this.hashCode = pattern.getKey().location().hashCode() + parts.entrySet().stream().mapToInt(entry -> (Objects.hashCode(entry.getKey()) ^ Objects.hashCode(entry.getValue())) * (int)Math.pow(31.0, i.getAndIncrement())).sum();
    }

    private JewelryData(Holder<PatternDefinition> pattern, Map<Holder<PartDefinition>, Holder<MaterialDefinition>> parts, boolean valid, List<BonusInstance> bonuses) {
        this.pattern = pattern;
        this.parts = parts;
        this.valid = valid;
        this.bonuses = bonuses;
        this.hashCode = parts.hashCode();
    }

    public static JewelryData renderable(Holder<PatternDefinition> pattern, Map<Holder<PartDefinition>, Holder<MaterialDefinition>> parts) {
        return new JewelryData(pattern, parts, true, List.of());
    }

    private JewelryData() {
        this.pattern = null;
        this.valid = false;
        this.parts = Map.of();
        this.bonuses = List.of();
        this.hashCode = 0;
    }

    @NotNull
    public static JewelryData get(ItemStack itemStack) {
        return (JewelryData)itemStack.getOrDefault(ComponentRegistry.JEWELRY_COMPONENT, (Object)NONE);
    }

    public static void set(ItemStack itemStack, JewelryData data) {
        itemStack.set(ComponentRegistry.JEWELRY_COMPONENT, (Object)data);
    }

    public static void ifPresent(ItemStack itemStack, Consumer<JewelryData> consumer) {
        JewelryData data = (JewelryData)itemStack.get(ComponentRegistry.JEWELRY_COMPONENT);
        if (data != null) {
            consumer.accept(data);
        }
    }

    public <T> void forBonuses(BonusType bonusType, Class<T> clazz, BiConsumer<BonusInstance, T> consumer) {
        List<BonusInstance> bonuses = this.getBonuses();
        for (BonusInstance instance : bonuses) {
            if (!instance.bonusType().equals(bonusType)) continue;
            instance.bonusType().getParameterType().resolve(instance).ifPresent(param -> {
                if (clazz.isInstance(param)) {
                    consumer.accept(instance, param);
                }
            });
        }
    }

    private boolean validate() {
        if (this.pattern == null || this.parts.size() != ((PatternDefinition)this.pattern.value()).partTemplate().size()) {
            return false;
        }
        for (PartIngredient part : ((PatternDefinition)this.pattern.value()).partTemplate()) {
            if (this.parts.containsKey(part.part())) continue;
            return false;
        }
        return true;
    }

    public Map<Holder<PartDefinition>, Holder<MaterialDefinition>> parts() {
        return this.parts;
    }

    public boolean isValid() {
        return this.valid;
    }

    private List<BonusInstance> cacheBonuses() {
        if (!this.valid) {
            return List.of();
        }
        return ((PatternDefinition)this.pattern.value()).bonuses().stream().map(this::getBonusFor).filter(inst -> inst.bonusType().getParameterType().equals(ParameterTypeRegistry.EMPTY.get()) || !inst.parameter().isEmpty()).toList();
    }

    public BonusInstance getBonusFor(Tuple<PartIngredient, Bonus> tuple) {
        Bonus bonus = (Bonus)tuple.getB();
        BonusType type = bonus.bonusType();
        double totalQuality = ((PatternDefinition)this.pattern.value()).qualityMultiplier() * bonus.qualityMultiplier() * ((PatternDefinition)this.pattern.value()).partForQuality().map(PartDefinition2 -> ((MaterialDefinition)this.parts.get(PartDefinition2).value()).quality()).orElse(1.0);
        Optional<QualityScalar> cooldown = bonus.cooldown();
        Map<IBonusParameterType<?>, Object> allParameters = bonus.parameterValue().containsKey(bonus.bonusType().getParameterType()) ? bonus.parameterValue() : MaterialModifierDataHandler.getParametersWithOverrides(this.parts.get(((PartIngredient)tuple.getA()).part()));
        Map<IBonusParameterType<?>, Object> parameter = allParameters.containsKey(type.getParameterType()) ? Map.of(type.getParameterType(), allParameters.get(type.getParameterType())) : Map.of();
        return new BonusInstance(type, totalQuality, parameter, cooldown);
    }

    public Component getItemName() {
        if (!this.isValid()) {
            return Component.translatable((String)"item.irons_jewelry.invalid_jewelry");
        }
        List<PartIngredient> parts = ((PatternDefinition)this.pattern.value()).partTemplate();
        Object[] ids = new Component[parts.size()];
        for (int i = 0; i < parts.size(); ++i) {
            ids[parts.size() - 1 - i] = Component.translatable((String)((MaterialDefinition)this.parts.get(parts.get(i).part()).value()).descriptionId());
        }
        String descriptionId = ((PatternDefinition)this.pattern.value()).descriptionId();
        HashMap duplicates = new HashMap();
        this.parts.forEach((part, material) -> {
            if (!((PatternDefinition)this.pattern.value()).partForQuality().map(ignore -> ((PartDefinition)ignore.value()).equals(part.value())).orElse(false).booleanValue()) {
                Integer count;
                Integer n = count = duplicates.getOrDefault(material, 0);
                count = count + 1;
                duplicates.put(material, count);
            }
        });
        boolean dirty = false;
        MutableComponent directTranslation = Component.translatable((String)(descriptionId + ".item"), (Object[])ids);
        String rasterizedTranslation = directTranslation.getString();
        for (Map.Entry entry : duplicates.entrySet()) {
            Holder material2 = (Holder)entry.getKey();
            Integer count = (Integer)entry.getValue();
            if (count <= 1) continue;
            for (int i = 0; i < count - 1; ++i) {
                rasterizedTranslation = rasterizedTranslation.replaceFirst(String.format("%s-", Component.translatable((String)((MaterialDefinition)material2.value()).descriptionId()).getString()), "");
                dirty = true;
            }
        }
        if (dirty) {
            return Component.literal((String)rasterizedTranslation);
        }
        return directTranslation;
    }

    public List<BonusInstance> getBonuses() {
        return this.bonuses;
    }

    public Holder<PatternDefinition> pattern() {
        return this.pattern;
    }

    public int hashCode() {
        return this.hashCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof JewelryData)) return false;
        JewelryData other = (JewelryData)obj;
        if (!this.pattern.equals(other.pattern)) return false;
        if (!this.parts.equals(other.parts)) return false;
        return true;
    }
}

