/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.core.bonuses;

import io.redspace.ironsjewelry.core.bonuses.BonusType;
import io.redspace.ironsjewelry.core.data.BonusInstance;
import io.redspace.ironsjewelry.core.parameters.EffectParameter;
import io.redspace.ironsjewelry.registry.ParameterTypeRegistry;
import io.redspace.ironsjewelry.utils.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;

public class EffectOnHitBonusType
extends BonusType {
    public EffectParameter getParameterType() {
        return ParameterTypeRegistry.POSITIVE_EFFECT_PARAMETER.get();
    }

    @Override
    public List<Component> getTooltipDescription(BonusInstance bonus) {
        Optional param = this.getParameterType().resolve(bonus.parameter());
        if (param.isPresent()) {
            Holder effect = (Holder)param.get();
            return List.of(Component.literal((String)" ").append((Component)Component.translatable((String)(this.getDescriptionId() + ".description"), (Object[])new Object[]{Component.translatable((String)((MobEffect)effect.value()).getDescriptionId()).withStyle(ChatFormatting.GREEN), Component.literal((String)Utils.digitalTimeFromTicks(this.durationInTicks((Holder<MobEffect>)effect, bonus.quality()))).withStyle(ChatFormatting.GREEN)}).withStyle(ChatFormatting.YELLOW)));
        }
        return super.getTooltipDescription(bonus);
    }

    public int durationInTicks(Holder<MobEffect> effect, double quality) {
        return ((MobEffect)effect.value()).isInstantenous() ? 0 : (int)(200.0 + 100.0 * quality);
    }
}

