/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.core.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsjewelry.core.actions.IAction;
import io.redspace.ironsjewelry.core.actions.IgnorableExplosion;
import io.redspace.ironsjewelry.core.data.BonusInstance;
import io.redspace.ironsjewelry.core.data.QualityScalar;
import io.redspace.ironsjewelry.utils.Utils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public record ExplodeAction(boolean affectSelf, boolean attributeToUser, String translation, Optional<Holder<DamageType>> damageType, Optional<QualityScalar> knockbackMultiplier, Optional<HolderSet<Block>> immuneBlocks, Vec3 offset, QualityScalar radius, boolean createFire, Level.ExplosionInteraction blockInteraction, ParticleOptions smallParticle, ParticleOptions largeParticle, Holder<SoundEvent> sound) implements IAction
{
    public static final MapCodec<ExplodeAction> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.BOOL.optionalFieldOf("affect_self", (Object)true).forGetter(ExplodeAction::affectSelf), (App)Codec.BOOL.optionalFieldOf("attribute_to_user", (Object)false).forGetter(ExplodeAction::attributeToUser), (App)Codec.STRING.fieldOf("translation").forGetter(ExplodeAction::translation), (App)DamageType.CODEC.optionalFieldOf("damage_type").forGetter(ExplodeAction::damageType), (App)QualityScalar.CODEC.optionalFieldOf("knockback_multiplier").forGetter(ExplodeAction::knockbackMultiplier), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).optionalFieldOf("immune_blocks").forGetter(ExplodeAction::immuneBlocks), (App)Vec3.CODEC.optionalFieldOf("offset", (Object)Vec3.ZERO).forGetter(ExplodeAction::offset), (App)QualityScalar.CODEC.fieldOf("radius").forGetter(ExplodeAction::radius), (App)Codec.BOOL.optionalFieldOf("create_fire", (Object)false).forGetter(ExplodeAction::createFire), (App)Level.ExplosionInteraction.CODEC.fieldOf("block_interaction").forGetter(ExplodeAction::blockInteraction), (App)ParticleTypes.CODEC.fieldOf("small_particle").forGetter(ExplodeAction::smallParticle), (App)ParticleTypes.CODEC.fieldOf("large_particle").forGetter(ExplodeAction::largeParticle), (App)SoundEvent.CODEC.fieldOf("sound").forGetter(ExplodeAction::sound)).apply((Applicative)builder, ExplodeAction::new));

    @Override
    public void apply(ServerLevel serverLevel, double quality, boolean applyToSelf, ServerPlayer wearer, Entity entity) {
        Vec3 origin = (applyToSelf ? wearer : entity).position().add(serverLevel.random.nextDouble() * 0.1 - 0.05, serverLevel.random.nextDouble() * 0.2 + 0.2, serverLevel.random.nextDouble() * 0.1 - 0.05);
        Vec3 vec3 = origin.add(this.offset);
        float exRadius = Math.max((float)this.radius.sample(quality), 0.0f);
        IgnorableExplosion explosion = new IgnorableExplosion((Level)serverLevel, this.affectSelf, (Entity)wearer, (Entity)(this.attributeToUser ? wearer : null), this.getDamageSource((Entity)wearer, vec3), (ExplosionDamageCalculator)new SimpleExplosionDamageCalculator(this.blockInteraction != Level.ExplosionInteraction.NONE, this.damageType.isPresent(), this.knockbackMultiplier.map(p_345018_ -> Float.valueOf((float)p_345018_.sample(quality))), this.immuneBlocks), vec3.x(), vec3.y(), vec3.z(), exRadius, this.createFire, Explosion.BlockInteraction.KEEP, this.smallParticle, this.largeParticle, this.sound);
        if (EventHooks.onExplosionStart((Level)serverLevel, (Explosion)explosion)) {
            return;
        }
        explosion.explode();
        explosion.finalizeExplosion(true);
        if (!explosion.interactsWithBlocks()) {
            explosion.clearToBlow();
        }
        for (ServerPlayer serverplayer2 : serverLevel.getPlayers(serverplayer -> serverplayer.distanceToSqr(vec3) < 4096.0)) {
            serverplayer2.connection.send((Packet)new ClientboundExplodePacket(vec3.x, vec3.y, vec3.z, exRadius, explosion.getToBlow(), (Vec3)explosion.getHitPlayers().get(serverplayer2), explosion.getBlockInteraction(), explosion.getSmallExplosionParticles(), explosion.getLargeExplosionParticles(), explosion.getExplosionSound()));
        }
    }

    @Nullable
    private DamageSource getDamageSource(Entity pEntity, Vec3 pPos) {
        if (this.damageType.isEmpty()) {
            return null;
        }
        return this.attributeToUser ? new DamageSource(this.damageType.get(), pEntity) : new DamageSource(this.damageType.get(), pPos);
    }

    @Override
    public Component formatTooltip(BonusInstance bonusInstance, boolean applyToSelf) {
        String string = applyToSelf ? "action.irons_jewelry.explode.self" : "action.irons_jewelry.explode";
        return Component.translatable((String)string, (Object[])new Object[]{Component.translatable((String)this.translation).withStyle(ChatFormatting.RED), Utils.stringTruncation(this.radius.sample(bonusInstance.quality()), 1)});
    }

    @Override
    public Component simpleDescription(MutableComponent actionName) {
        return this.formatTooltip(new BonusInstance(null, 1.0, null, null), false);
    }

    @Override
    public MapCodec<? extends IAction> codec() {
        return CODEC;
    }
}

