/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.worldgen.features.crops;

import com.lance5057.extradelight.worldgen.config.WildConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class WildCropFeature
extends Feature<WildConfig> {
    private final Block crop;

    public WildCropFeature(Block crop) {
        super(WildConfig.CODEC);
        this.crop = crop;
    }

    public boolean place(FeaturePlaceContext<WildConfig> pContext) {
        WildConfig WildConfig2 = (WildConfig)pContext.config();
        RandomSource randomsource = pContext.random();
        BlockPos blockpos = pContext.origin();
        WorldGenLevel worldgenlevel = pContext.level();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int j = WildConfig2.xzSpread() + 1;
        int k = WildConfig2.ySpread() + 1;
        int generated = 0;
        int maxCount = randomsource.nextIntBetweenInclusive(WildConfig2.minCount(), WildConfig2.maxCount());
        for (int tryCount = 0; tryCount < WildConfig2.tries() && generated < maxCount; ++tryCount) {
            pos.setWithOffset((Vec3i)blockpos, randomsource.nextInt(j) - randomsource.nextInt(j), randomsource.nextInt(k) - randomsource.nextInt(k), randomsource.nextInt(j) - randomsource.nextInt(j));
            if (!worldgenlevel.isEmptyBlock((BlockPos)pos) && !worldgenlevel.getBlockState((BlockPos)pos).is(BlockTags.SNOW) || !this.crop.defaultBlockState().canSurvive((LevelReader)worldgenlevel, (BlockPos)pos)) continue;
            this.spawn((LevelAccessor)worldgenlevel, randomsource, (BlockPos)pos);
            ++generated;
        }
        return generated > 0;
    }

    private List<BlockPos> getAdjacentBlocks(BlockPos blockpos) {
        return new ArrayList<BlockPos>(Arrays.asList(blockpos.east(), blockpos.west(), blockpos.north(), blockpos.south(), blockpos.north().east(), blockpos.north().west(), blockpos.south().east(), blockpos.south().west()));
    }

    private void spawn(LevelAccessor worldIn, RandomSource rand, BlockPos generatingPos) {
        worldIn.setBlock(generatingPos, this.crop.defaultBlockState(), 2);
    }
}

