/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.vat;

import com.lance5057.extradelight.gui.widgets.FancyTankWidget;
import com.lance5057.extradelight.workstations.vat.VatMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class VatScreen
extends AbstractContainerScreen<VatMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"textures/gui/vat.png");
    private static final Rectangle PROGRESS_ARROW = new Rectangle(0, 184, 87, 18);

    public VatScreen(VatMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    public void init() {
        super.init();
        this.addRenderableOnly((Renderable)new FancyTankWidget(this.leftPos + 32, this.topPos - 5, 16, 72, ((VatMenu)this.menu)::getFluidTank));
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        super.render(gui, mouseX, mouseY, partialTicks);
        this.renderTooltip(gui, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.minecraft == null) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
        graphics.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos - 19, 0, 0, 175, 183);
        int l = ((VatMenu)this.menu).tileEntity.getCookTimeTotal();
        int m = ((VatMenu)this.menu).tileEntity.getCookTime();
        DecimalFormat df = new DecimalFormat("##.##");
        df.setRoundingMode(RoundingMode.UP);
        graphics.drawString(this.font, df.format((float)(l - m) / 24000.0f) + " Days", this.leftPos + 95, this.topPos + 56, 0x404040, false);
        if (l != 0) {
            graphics.drawString(this.font, "Stage", this.leftPos + 125, this.topPos, 0x404040, false);
            if (((VatMenu)this.menu).tileEntity.isLidRequired() && !((VatMenu)this.menu).tileEntity.isHasLid()) {
                graphics.drawString(this.font, " Needs Lid!", this.leftPos + 110, this.topPos + 20, 0xFF0000, false);
            } else if (!((VatMenu)this.menu).tileEntity.isLidRequired() && ((VatMenu)this.menu).tileEntity.isHasLid()) {
                graphics.drawString(this.font, "Remove Lid!", this.leftPos + 113, this.topPos + 20, 0xFF0000, false);
            }
            graphics.drawString(this.font, ((VatMenu)this.menu).tileEntity.getStage() + "/" + ((VatMenu)this.menu).tileEntity.getStageTotal(), this.leftPos + 131, this.topPos + 10, 0x404040, false);
        }
        graphics.blit(BACKGROUND_TEXTURE, this.leftPos + 62, this.topPos + 31, VatScreen.PROGRESS_ARROW.x, VatScreen.PROGRESS_ARROW.y, m != 0 && l != 0 ? m * 87 / l : 0, VatScreen.PROGRESS_ARROW.height);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }
}

