/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.vat;

import com.lance5057.extradelight.ExtraDelightBlocks;
import com.lance5057.extradelight.ExtraDelightContainers;
import com.lance5057.extradelight.gui.FancyTankInSlot;
import com.lance5057.extradelight.gui.FancyTankOutSlot;
import com.lance5057.extradelight.workstations.FancyTank;
import com.lance5057.extradelight.workstations.vat.VatBlockEntity;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class VatMenu
extends AbstractContainerMenu {
    public static final ResourceLocation EMPTY_CATALYST_SLOT = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"item/empty_catalyst_slot");
    public static final ResourceLocation EMPTY_CONTAINER_SLOT_BOWL = ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"item/empty_container_slot_bowl");
    public static final ResourceLocation EMPTY_CONTAINER_SLOT_BUCKET = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"item/empty_container_slot_bucket");
    public final VatBlockEntity tileEntity;
    private final ContainerLevelAccess canInteractWithCallable;
    protected final Level level;

    protected VatMenu(int windowId, Inventory playerInventory, VatBlockEntity tileEntity) {
        super(ExtraDelightContainers.VAT_MENU.get(), windowId);
        this.tileEntity = tileEntity;
        this.level = playerInventory.player.level();
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)tileEntity.getLevel(), (BlockPos)tileEntity.getBlockPos());
        if (tileEntity != null) {
            int column;
            int startX = 8;
            int startY = 8;
            int inputStartX = 55;
            int inputStartY = -5;
            int borderSlotSize = 18;
            for (int row = 0; row < 2; ++row) {
                for (column = 0; column < 3; ++column) {
                    this.addSlot((Slot)new SlotItemHandler((IItemHandler)tileEntity.getItemHandler(), row * 3 + column, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize));
                }
            }
            this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)tileEntity.getItemHandler(), 7, 55, 51){

                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_CATALYST_SLOT);
                }
            });
            this.addSlot((Slot)new FancyTankInSlot(this, (IItemHandler)tileEntity.getItemHandler(), tileEntity.getFluidTank(), 8, 8, -5){

                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_CONTAINER_SLOT_BUCKET);
                }
            });
            this.addSlot((Slot)new FancyTankOutSlot((IItemHandler)tileEntity.getItemHandler(), tileEntity.getFluidTank(), 9, 8, 51));
            this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)tileEntity.getItemHandler(), 6, 151, 32){

                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_CONTAINER_SLOT_BOWL);
                }
            });
            this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)tileEntity.getItemHandler(), 10, 151, 51){

                public boolean mayPlace(ItemStack stack) {
                    return false;
                }
            });
            int startPlayerInvY = startY * 4 + 51;
            for (int row = 0; row < 3; ++row) {
                for (int column2 = 0; column2 < 9; ++column2) {
                    this.addSlot(new Slot((Container)playerInventory, 9 + row * 9 + column2, startX + column2 * borderSlotSize, startPlayerInvY + row * borderSlotSize));
                }
            }
            for (column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)playerInventory, column, startX + column * borderSlotSize, 141));
            }
        }
    }

    public VatMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, VatMenu.getTileEntity(playerInventory, data));
    }

    public FancyTank getFluidTank() {
        return this.tileEntity.getFluidTank();
    }

    private static VatBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof VatBlockEntity) {
            return (VatBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + String.valueOf(tileAtPos));
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        int indexOutput;
        int startPlayerInv = indexOutput = 9;
        int endPlayerInv = startPlayerInv + 36;
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (pIndex < startPlayerInv ? !this.moveItemStackTo(itemstack1, startPlayerInv, endPlayerInv, true) : !this.moveItemStackTo(itemstack1, 0, indexOutput, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, itemstack1);
        }
        return itemstack;
    }

    public boolean stillValid(Player pPlayer) {
        return VatMenu.stillValid((ContainerLevelAccess)this.canInteractWithCallable, (Player)pPlayer, (Block)((Block)ExtraDelightBlocks.VAT.get()));
    }
}

