/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.oven;

import com.lance5057.extradelight.ExtraDelightBlocks;
import com.lance5057.extradelight.ExtraDelightContainers;
import com.lance5057.extradelight.ExtraDelightTags;
import com.lance5057.extradelight.workstations.oven.OvenBlockEntity;
import com.lance5057.extradelight.workstations.oven.recipes.OvenRecipe;
import com.lance5057.extradelight.workstations.oven.slots.OvenResultSlot;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class OvenMenu
extends RecipeBookMenu<RecipeWrapper, OvenRecipe> {
    public static final ResourceLocation EMPTY_CONTAINER_SLOT_BOWL = ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"item/empty_container_slot_bowl");
    public final OvenBlockEntity tileEntity;
    public final ItemStackHandler inventory;
    private final ContainerData OvenData;
    private final ContainerLevelAccess canInteractWithCallable;
    protected final Level level;

    public OvenMenu(int windowId, Inventory playerInventory, OvenBlockEntity tileEntity, ContainerData OvenDataIn) {
        super(ExtraDelightContainers.OVEN_MENU.get(), windowId);
        int column;
        this.tileEntity = tileEntity;
        this.inventory = tileEntity.getInventory();
        this.OvenData = OvenDataIn;
        this.level = playerInventory.player.level();
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)tileEntity.getLevel(), (BlockPos)tileEntity.getBlockPos());
        int startX = 8;
        int startY = 18;
        int inputStartX = 30;
        int inputStartY = 17;
        int borderSlotSize = 18;
        for (int row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, row * 3 + column, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize));
            }
        }
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.inventory, 10, 92, 63){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_CONTAINER_SLOT_BOWL);
            }
        });
        this.addSlot((Slot)new OvenResultSlot(playerInventory.player, tileEntity, (IItemHandler)this.inventory, 11, 124, 36));
        int startPlayerInvY = startY * 4 + 30;
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.addSlot(new Slot((Container)playerInventory, 9 + row * 9 + column2, startX + column2 * borderSlotSize, startPlayerInvY + row * borderSlotSize));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.addSlot(new Slot((Container)playerInventory, column, startX + column * borderSlotSize, 160));
        }
        this.addDataSlots(OvenDataIn);
    }

    private static OvenBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof OvenBlockEntity) {
            return (OvenBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + String.valueOf(tileAtPos));
    }

    public OvenMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, OvenMenu.getTileEntity(playerInventory, data), (ContainerData)new SimpleContainerData(4));
    }

    public boolean stillValid(Player playerIn) {
        return OvenMenu.stillValid((ContainerLevelAccess)this.canInteractWithCallable, (Player)playerIn, (Block)((Block)ExtraDelightBlocks.OVEN.get()));
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        int indexContainerInput = 9;
        int indexOutput = 10;
        int startPlayerInv = indexOutput + 1;
        int endPlayerInv = startPlayerInv + 36;
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < indexOutput ? !this.moveItemStackTo(itemstack1, startPlayerInv, endPlayerInv, true) : index > indexOutput && (itemstack1.is(ExtraDelightTags.TRAYS) ? !this.moveItemStackTo(itemstack1, indexContainerInput, indexContainerInput + 1, false) : !this.moveItemStackTo(itemstack1, 0, indexContainerInput, false))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookProgressionScaled() {
        int i = this.OvenData.get(0);
        int j = this.OvenData.get(1);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isHeated() {
        return this.tileEntity.isHeated();
    }

    public void fillCraftSlotsStackedContents(StackedContents helper) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            helper.accountSimpleStack(this.inventory.getStackInSlot(i));
        }
    }

    public void clearCraftingContent() {
        for (int i = 0; i < 12; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public int getResultSlotIndex() {
        return 11;
    }

    public int getGridWidth() {
        return 3;
    }

    public int getGridHeight() {
        return 3;
    }

    public int getSize() {
        return 10;
    }

    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.valueOf((String)"EXTRADELIGHT_COOKING");
    }

    public boolean shouldMoveToInventory(int slot) {
        return slot < this.getGridWidth() * this.getGridHeight();
    }

    public boolean recipeMatches(RecipeHolder<OvenRecipe> recipe) {
        return ((OvenRecipe)recipe.value()).matches(new RecipeWrapper((IItemHandler)this.inventory), this.level);
    }
}

