/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.oven;

import com.google.common.collect.Lists;
import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.workstations.oven.OvenBlock;
import com.lance5057.extradelight.workstations.oven.OvenMenu;
import com.lance5057.extradelight.workstations.oven.inventory.OvenItemHandler;
import com.lance5057.extradelight.workstations.oven.recipes.OvenRecipe;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.item.component.ItemStackWrapper;
import vectorwing.farmersdelight.common.registry.ModDataComponents;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class OvenBlockEntity
extends SyncedBlockEntity
implements MenuProvider,
HeatableBlockEntity,
Nameable,
RecipeCraftingHolder {
    public static final int MEAL_DISPLAY_SLOT = 9;
    public static final int CONTAINER_SLOT = 10;
    public static final int OUTPUT_SLOT = 11;
    public static final int INVENTORY_SIZE = 12;
    protected final ContainerData OvenData;
    private final ItemStackHandler inventory = this.createHandler();
    public final IItemHandler inputHandler = new OvenItemHandler((IItemHandler)this.inventory, Direction.UP);
    public final IItemHandler outputHandler = new OvenItemHandler((IItemHandler)this.inventory, Direction.DOWN);
    private final Object2IntOpenHashMap<ResourceLocation> usedRecipeTracker;
    private int cookTime;
    private int cookTimeTotal;
    private ItemStack mealContainerStack = ItemStack.EMPTY;
    private Component customName;
    private ResourceLocation lastRecipeID;
    private boolean checkNewRecipe;
    private final RecipeManager.CachedCheck<RecipeWrapper, OvenRecipe> quickCheck;

    public OvenBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExtraDelightBlockEntities.OVEN.get(), pos, state);
        this.OvenData = this.createIntArray();
        this.usedRecipeTracker = new Object2IntOpenHashMap();
        this.quickCheck = RecipeManager.createCheck(ExtraDelightRecipes.OVEN.get());
    }

    public static ItemStack getMealFromItem(ItemStack OvenStack) {
        if (!OvenStack.is((Item)ExtraDelightItems.OVEN.get())) {
            return ItemStack.EMPTY;
        }
        return ((ItemStackWrapper)OvenStack.getOrDefault((Supplier)ModDataComponents.MEAL, (Object)ItemStackWrapper.EMPTY)).getStack();
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ExtraDelightBlockEntities.OVEN.get(), (be, context) -> {
            if (context == Direction.UP) {
                return be.inputHandler;
            }
            return be.outputHandler;
        });
    }

    public static ItemStack getContainerFromItem(ItemStack OvenStack) {
        if (!OvenStack.is((Item)ExtraDelightItems.OVEN.get())) {
            return ItemStack.EMPTY;
        }
        return ((ItemStackWrapper)OvenStack.getOrDefault((DataComponentType)ModDataComponents.CONTAINER.get(), (Object)ItemStackWrapper.EMPTY)).getStack();
    }

    public static void cookingTick(Level level, BlockPos pos, BlockState state, OvenBlockEntity Oven) {
        boolean isHeated = Oven.isHeated(level, pos);
        boolean didInventoryChange = false;
        Optional<RecipeHolder<OvenRecipe>> recipe = Oven.getMatchingRecipe(new RecipeWrapper((IItemHandler)Oven.inventory));
        if (isHeated && Oven.hasInput()) {
            if (recipe.isPresent() && Oven.canCook((OvenRecipe)recipe.get().value())) {
                didInventoryChange = Oven.processCooking(recipe.get(), Oven);
            } else {
                Oven.cookTime = 0;
            }
        } else if (Oven.cookTime > 0) {
            Oven.cookTime = Mth.clamp((int)(Oven.cookTime - 2), (int)0, (int)Oven.cookTimeTotal);
        }
        ItemStack mealStack = Oven.getMeal();
        if (!mealStack.isEmpty()) {
            if (!Oven.doesMealHaveContainer(mealStack)) {
                Oven.moveMealToOutput();
                didInventoryChange = true;
            } else if (!Oven.inventory.getStackInSlot(10).isEmpty()) {
                didInventoryChange = true;
            }
        }
        if (didInventoryChange) {
            Oven.inventoryChanged();
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, OvenBlockEntity Oven) {
        if (Oven.isHeated(level, pos)) {
            double z;
            double y;
            double x;
            RandomSource random = level.random;
            if (random.nextFloat() < 0.2f) {
                x = (double)pos.getX() + 0.5 + (random.nextDouble() * 0.6 - 0.3);
                y = (double)pos.getY() + 0.1;
                z = (double)pos.getZ() + 0.5 + (random.nextDouble() * 0.6 - 0.3);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
            }
            if (random.nextFloat() < 0.05f) {
                x = (double)pos.getX() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
                y = (double)pos.getY() + 0.5;
                z = (double)pos.getZ() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
                double motionY = random.nextBoolean() ? 0.015 : 0.005;
                level.addParticle((ParticleOptions)ModParticleTypes.STEAM.get(), x, y, z, 0.0, motionY, 0.0);
            }
        }
    }

    private static void splitAndSpawnExperience(ServerLevel level, Vec3 pos, int craftedAmount, float experience) {
        int expTotal = Mth.floor((float)((float)craftedAmount * experience));
        float expFraction = Mth.frac((float)((float)craftedAmount * experience));
        if (expFraction != 0.0f && Math.random() < (double)expFraction) {
            ++expTotal;
        }
        ExperienceOrb.award((ServerLevel)level, (Vec3)pos, (int)expTotal);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
        this.cookTime = compound.getInt("CookTime");
        this.cookTimeTotal = compound.getInt("CookTimeTotal");
        this.mealContainerStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compound.getCompound("Container"));
        if (compound.contains("CustomName", 8)) {
            this.customName = Component.Serializer.fromJson((String)compound.getString("CustomName"), (HolderLookup.Provider)registries);
        }
        CompoundTag compoundRecipes = compound.getCompound("RecipesUsed");
        for (String key : compoundRecipes.getAllKeys()) {
            this.usedRecipeTracker.put((Object)ResourceLocation.parse((String)key), compoundRecipes.getInt(key));
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("CookTime", this.cookTime);
        compound.putInt("CookTimeTotal", this.cookTimeTotal);
        compound.put("Container", this.mealContainerStack.saveOptional(registries));
        if (this.customName != null) {
            compound.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)registries));
        }
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        CompoundTag compoundRecipes = new CompoundTag();
        this.usedRecipeTracker.forEach((recipeId, craftedAmount) -> compoundRecipes.putInt(recipeId.toString(), craftedAmount.intValue()));
        compound.put("RecipesUsed", (Tag)compoundRecipes);
    }

    private CompoundTag writeItems(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.put("Container", this.mealContainerStack.saveOptional(registries));
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        return compound;
    }

    public CompoundTag writeMeal(CompoundTag compound, HolderLookup.Provider registries) {
        if (this.getMeal().isEmpty()) {
            return compound;
        }
        ItemStackHandler drops = new ItemStackHandler(12);
        for (int i = 0; i < 12; ++i) {
            drops.setStackInSlot(i, i == 9 ? this.inventory.getStackInSlot(i) : ItemStack.EMPTY);
        }
        if (this.customName != null) {
            compound.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)registries));
        }
        compound.put("Container", this.mealContainerStack.save(registries));
        compound.put("Inventory", (Tag)drops.serializeNBT(registries));
        return compound;
    }

    private Optional<RecipeHolder<OvenRecipe>> getMatchingRecipe(RecipeWrapper inventoryWrapper) {
        if (this.level == null) {
            return Optional.empty();
        }
        return this.hasInput() ? this.quickCheck.getRecipeFor((RecipeInput)inventoryWrapper, this.level) : Optional.empty();
    }

    public ItemStack getContainer() {
        if (!this.mealContainerStack.isEmpty()) {
            return this.mealContainerStack;
        }
        return this.getMeal().getCraftingRemainingItem().copy();
    }

    private boolean hasInput() {
        for (int i = 0; i < 9; ++i) {
            if (this.inventory.getStackInSlot(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected boolean canCook(OvenRecipe recipe) {
        if (this.hasInput()) {
            ItemStack resultStack = recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess());
            if (this.inventory.getStackInSlot(10).getItem() != recipe.getOutputContainer().getItem()) {
                return false;
            }
            if (resultStack.isEmpty()) {
                return false;
            }
            ItemStack storedMealStack = this.inventory.getStackInSlot(11);
            if (storedMealStack.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItem((ItemStack)storedMealStack, (ItemStack)resultStack)) {
                return false;
            }
            if (storedMealStack.getCount() + resultStack.getCount() <= this.inventory.getSlotLimit(11) && storedMealStack.getCount() + resultStack.getCount() <= resultStack.getMaxStackSize()) {
                return true;
            }
        }
        return false;
    }

    private boolean processCooking(RecipeHolder<OvenRecipe> recipe, OvenBlockEntity oven) {
        if (this.level == null) {
            return false;
        }
        ++this.cookTime;
        this.cookTimeTotal = ((OvenRecipe)recipe.value()).getCookTime();
        if (this.cookTime < this.cookTimeTotal) {
            return false;
        }
        this.cookTime = 0;
        this.mealContainerStack = ((OvenRecipe)recipe.value()).getOutputContainer();
        ItemStack containerInputStack = this.inventory.getStackInSlot(10);
        ItemStack resultStack = ((OvenRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
        ItemStack storedMealStack = this.inventory.getStackInSlot(11);
        if (storedMealStack.isEmpty()) {
            this.inventory.setStackInSlot(11, resultStack.copy());
        } else if (ItemStack.isSameItem((ItemStack)resultStack, (ItemStack)storedMealStack) && storedMealStack.getCount() + resultStack.getCount() <= storedMealStack.getMaxStackSize()) {
            storedMealStack.grow(resultStack.getCount());
        }
        oven.setRecipeUsed(recipe);
        for (int i = 0; i < 9; ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (slotStack.hasCraftingRemainingItem()) {
                Direction direction = ((Direction)this.getBlockState().getValue((Property)OvenBlock.FACING)).getCounterClockWise();
                double x = (double)this.worldPosition.getX() + 0.5 + (double)direction.getStepX() * 0.25;
                double y = (double)this.worldPosition.getY() + 0.7;
                double z = (double)this.worldPosition.getZ() + 0.5 + (double)direction.getStepZ() * 0.25;
                ItemUtils.spawnItemEntity((Level)this.level, (ItemStack)this.inventory.getStackInSlot(i).getCraftingRemainingItem().copy(), (double)x, (double)y, (double)z, (double)((float)direction.getStepX() * 0.08f), (double)0.25, (double)((float)direction.getStepZ() * 0.08f));
            }
            if (slotStack.isEmpty()) continue;
            slotStack.shrink(1);
        }
        if (((OvenRecipe)recipe.value()).shouldConsumeContainer()) {
            containerInputStack.shrink(1);
        }
        return true;
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceLocation recipeID = recipe.id();
            this.usedRecipeTracker.addTo((Object)recipeID, 1);
        }
    }

    public void awardUsedRecipes(Player player, List<ItemStack> items) {
        List<RecipeHolder<?>> usedRecipes = this.getUsedRecipesAndPopExperience(player.level(), player.position());
        player.awardRecipes(usedRecipes);
        this.usedRecipeTracker.clear();
    }

    public List<RecipeHolder<?>> getUsedRecipesAndPopExperience(Level level, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.usedRecipeTracker.object2IntEntrySet()) {
            level.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                OvenBlockEntity.splitAndSpawnExperience((ServerLevel)level, pos, entry.getIntValue(), ((OvenRecipe)recipe.value()).getExperience());
            });
        }
        return list;
    }

    public boolean isHeated() {
        if (this.level == null) {
            return false;
        }
        return this.isHeated(this.level, this.worldPosition);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getMeal() {
        return this.inventory.getStackInSlot(9);
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.create();
        for (int i = 0; i < 12; ++i) {
            if (i == 9) continue;
            drops.add((Object)this.inventory.getStackInSlot(i));
        }
        return drops;
    }

    private void moveMealToOutput() {
        ItemStack mealStack = this.inventory.getStackInSlot(9);
        ItemStack outputStack = this.inventory.getStackInSlot(11);
        int mealCount = Math.min(mealStack.getCount(), mealStack.getMaxStackSize() - outputStack.getCount());
        if (outputStack.isEmpty()) {
            this.inventory.setStackInSlot(11, mealStack.split(mealCount));
        } else if (outputStack.getItem() == mealStack.getItem()) {
            mealStack.shrink(mealCount);
            outputStack.grow(mealCount);
        }
    }

    private void useStoredContainersOnMeal(boolean b) {
        ItemStack mealStack = this.inventory.getStackInSlot(9);
        ItemStack containerInputStack = this.inventory.getStackInSlot(10);
        ItemStack outputStack = this.inventory.getStackInSlot(11);
        if (this.isContainerValid(containerInputStack) && outputStack.getCount() < outputStack.getMaxStackSize()) {
            int smallerStackCount = Math.min(mealStack.getCount(), containerInputStack.getCount());
            int mealCount = Math.min(smallerStackCount, mealStack.getMaxStackSize() - outputStack.getCount());
            if (outputStack.isEmpty()) {
                if (!this.level.isClientSide && b) {
                    containerInputStack.shrink(1);
                }
                this.inventory.setStackInSlot(11, mealStack.split(mealCount));
            } else if (outputStack.getItem() == mealStack.getItem()) {
                mealStack.shrink(mealCount);
                outputStack.grow(mealCount);
            }
        }
    }

    private boolean doesMealHaveContainer(ItemStack meal) {
        return !this.mealContainerStack.isEmpty() || meal.hasCraftingRemainingItem();
    }

    public boolean isContainerValid(ItemStack containerItem) {
        if (containerItem.isEmpty()) {
            return false;
        }
        if (!this.mealContainerStack.isEmpty()) {
            return ItemStack.isSameItem((ItemStack)containerItem, (ItemStack)this.mealContainerStack);
        }
        return ItemStack.isSameItem((ItemStack)this.getMeal().getCraftingRemainingItem().copy(), (ItemStack)containerItem);
    }

    public Component getName() {
        return this.customName != null ? this.customName : Component.translatable((String)"extradelight.container.oven");
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public AbstractContainerMenu createMenu(int id, Inventory player, Player entity) {
        return new OvenMenu(id, player, this, this.OvenData);
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.writeItems(new CompoundTag(), registries);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(12){

            protected void onContentsChanged(int slot) {
                if (slot >= 0 && slot < 9 || slot == 10) {
                    OvenBlockEntity.this.checkNewRecipe = true;
                }
                OvenBlockEntity.this.inventoryChanged();
            }
        };
    }

    private ContainerData createIntArray() {
        return new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> OvenBlockEntity.this.cookTime;
                    case 1 -> OvenBlockEntity.this.cookTimeTotal;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        OvenBlockEntity.this.cookTime = value;
                        break;
                    }
                    case 1: {
                        OvenBlockEntity.this.cookTimeTotal = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }
}

