/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.mortar.recipes;

import com.lance5057.extradelight.ExtraDelightBlocks;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class MortarRecipe
extends SingleItemRecipe {
    protected final int grinds;
    protected final FluidStack fluidOut;

    public MortarRecipe(String pGroup, Ingredient pIngredient, ItemStack pResult, FluidStack fluidResult, int grinds) {
        super(ExtraDelightRecipes.MORTAR.get(), ExtraDelightRecipes.MORTAR_SERIALIZER.get(), pGroup, pIngredient, pResult);
        this.grinds = grinds;
        this.fluidOut = fluidResult;
    }

    public int getGrinds() {
        return this.grinds;
    }

    public FluidStack getFluid() {
        return this.fluidOut;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return this.ingredient.test(input.getItem(0));
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ExtraDelightBlocks.MORTAR_STONE.get());
    }

    public static class Serializer
    implements RecipeSerializer<MortarRecipe> {
        private static final MapCodec<MortarRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(SingleItemRecipe::getGroup), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(p_301068_ -> ((MortarRecipe)p_301068_).ingredient), (App)ItemStack.OPTIONAL_CODEC.fieldOf("result").forGetter(r -> ((MortarRecipe)r).result), (App)FluidStack.OPTIONAL_CODEC.fieldOf("fluidOut").forGetter(MortarRecipe::getFluid), (App)Codec.INT.optionalFieldOf("grinds", (Object)200).forGetter(MortarRecipe::getGrinds)).apply((Applicative)inst, MortarRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MortarRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static MortarRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
            String s = pBuffer.readUtf();
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
            ItemStack itemstack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)pBuffer);
            FluidStack fluid = (FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)pBuffer);
            int g = pBuffer.readInt();
            return new MortarRecipe(s, ingredient, itemstack, fluid, g);
        }

        public static void toNetwork(RegistryFriendlyByteBuf pBuffer, MortarRecipe pRecipe) {
            pBuffer.writeUtf(pRecipe.group);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.ingredient);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.result);
            FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.fluidOut);
            pBuffer.writeInt(pRecipe.grinds);
        }

        public MapCodec<MortarRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MortarRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

