/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.mixingbowl;

import com.lance5057.extradelight.blocks.interfaces.IStyleable;
import com.lance5057.extradelight.workstations.mixingbowl.MixingBowlBlockEntity;
import com.lance5057.extradelight.workstations.mixingbowl.MixingBowlMenu;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class MixingBowlBlock
extends Block
implements EntityBlock,
IStyleable {
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    public static final IntegerProperty STYLE = IntegerProperty.create((String)"style", (int)0, (int)(Styles.values().length - 1));

    public MixingBowlBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_WOOD).strength(0.5f, 1.0f).sound(SoundType.WOOD).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)STYLE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_53681_) {
        p_53681_.add(new Property[]{STYLE});
    }

    public boolean useShapeForLightOcclusion(BlockState pState) {
        return true;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public boolean isPathfindable(BlockState pState, PathComputationType pType) {
        return false;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity tileEntity = pLevel.getBlockEntity(pPos);
        if (tileEntity instanceof MixingBowlBlockEntity) {
            final MixingBowlBlockEntity mbe = (MixingBowlBlockEntity)tileEntity;
            if (stack.is(Tags.Items.EGGS)) {
                return mbe.handleEgg(pPlayer, stack);
            }
            InteractionResult result = mbe.mix(pPlayer, stack);
            if (result == InteractionResult.SUCCESS) {
                return ItemInteractionResult.SUCCESS;
            }
            MenuProvider containerProvider = new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"screen.mixing_bowl.name");
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                    return new MixingBowlMenu(windowId, playerInventory, mbe);
                }
            };
            pPlayer.openMenu(containerProvider, buf -> buf.writeBlockPos(pPos));
        }
        return ItemInteractionResult.CONSUME;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new MixingBowlBlockEntity(pPos, pState);
    }

    @Override
    public int numStyles() {
        return Styles.values().length;
    }

    @Override
    public int getCurrentStyle(BlockState state) {
        return (Integer)state.getValue((Property)STYLE);
    }

    @Override
    public void setNextStyle(Level level, BlockPos pos, BlockState state) {
        int next = (Integer)state.getValue((Property)STYLE) + 1;
        if ((Integer)state.getValue((Property)STYLE) >= this.numStyles() - 1) {
            next = 0;
        }
        for (int i = 0; i < 10; ++i) {
            level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SNOW_BLOCK.defaultBlockState()), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
        }
        level.playSound(null, pos, SoundEvents.SLIME_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        BlockState nextState = (BlockState)state.setValue((Property)STYLE, (Comparable)Integer.valueOf(next));
        level.setBlock(pos, nextState, 3);
    }

    @Override
    public void setPrevStyle(Level level, BlockPos pos, BlockState state) {
        int next = (Integer)state.getValue((Property)STYLE) - 1;
        if (next < 0) {
            next = this.numStyles() - 1;
        }
        for (int i = 0; i < 10; ++i) {
            level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SNOW_BLOCK.defaultBlockState()), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
        }
        level.playSound(null, pos, SoundEvents.SLIME_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        BlockState nextState = (BlockState)state.setValue((Property)STYLE, (Comparable)Integer.valueOf(next));
        level.setBlock(pos, nextState, 3);
    }

    @Override
    public BlockState getState(int i) {
        return (BlockState)this.defaultBlockState().setValue((Property)STYLE, (Comparable)Integer.valueOf(i));
    }

    @Override
    public void setStyle(Level level, BlockPos pos, BlockState state, int style) {
        BlockState nextState = (BlockState)state.setValue((Property)STYLE, (Comparable)Integer.valueOf(style));
        level.setBlock(pos, nextState, 3);
    }

    @Override
    public boolean isPatreonStyle(int style) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        MutableComponent textEmpty = Component.translatable((String)"extradelight.tooltip.styleable");
        tooltipComponents.add((Component)textEmpty.withStyle(ChatFormatting.AQUA));
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileEntity = level.getBlockEntity(pos);
            if (tileEntity instanceof MixingBowlBlockEntity) {
                MixingBowlBlockEntity te = (MixingBowlBlockEntity)tileEntity;
                IItemHandlerModifiable items = te.getItemHandler();
                for (int i = 0; i < te.getItemHandler().getSlots(); ++i) {
                    if (i == 12 || i == 13) continue;
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), items.getStackInSlot(i)));
                }
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.set(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY.with((Property)STYLE, (Comparable)((Integer)state.getValue((Property)STYLE))));
        return stack;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide && !player.isCreative() && level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
            ItemStack itemstack = new ItemStack((ItemLike)this);
            itemstack.set(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY.with((Property)STYLE, (Comparable)((Integer)state.getValue((Property)STYLE))));
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), itemstack);
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public static enum Styles {
        OAK_PLANKS,
        SPRUCE_PLANKS,
        BIRCH_PLANKS,
        DARK_OAK_PLANKS,
        ACACIA_PLANKS,
        MANGROVE_PLANKS,
        BAMBOO_PLANKS,
        CHERRY_PLANKS,
        JUNGLE_PLANKS,
        WARPED_PLANKS,
        CRIMSON_PLANKS,
        CINNAMON_PLANKS,
        FRUIT_PLANKS,
        GLASS,
        STONE,
        IRON_BLOCK,
        GOLD_BLOCK,
        TERRACOTTA,
        WHITE_TERRACOTTA,
        LIGHT_GRAY_TERRACOTTA,
        GRAY_TERRACOTTA,
        BLACK_TERRACOTTA,
        BROWN_TERRACOTTA,
        RED_TERRACOTTA,
        ORANGE_TERRACOTTA,
        YELLOW_TERRACOTTA,
        LIME_TERRACOTTA,
        GREEN_TERRACOTTA,
        CYAN_TERRACOTTA,
        LIGHT_BLUE_TERRACOTTA,
        BLUE_TERRACOTTA,
        MAGENTA_TERRACOTTA,
        PINK_TERRACOTTA,
        PURPLE_TERRACOTTA,
        WHITE_GLAZED_TERRACOTTA,
        LIGHT_GRAY_GLAZED_TERRACOTTA,
        GRAY_GLAZED_TERRACOTTA,
        BLACK_GLAZED_TERRACOTTA,
        BROWN_GLAZED_TERRACOTTA,
        RED_GLAZED_TERRACOTTA,
        ORANGE_GLAZED_TERRACOTTA,
        YELLOW_GLAZED_TERRACOTTA,
        LIME_GLAZED_TERRACOTTA,
        GREEN_GLAZED_TERRACOTTA,
        CYAN_GLAZED_TERRACOTTA,
        LIGHT_BLUE_GLAZED_TERRACOTTA,
        BLUE_GLAZED_TERRACOTTA,
        MAGENTA_GLAZED_TERRACOTTA,
        PINK_GLAZED_TERRACOTTA,
        PURPLE_GLAZED_TERRACOTTA;

    }
}

