/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.meltingpot;

import com.lance5057.extradelight.gui.widgets.FluidStackWidget;
import com.lance5057.extradelight.workstations.meltingpot.MeltingPotMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class MeltingPotScreen
extends AbstractContainerScreen<MeltingPotMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"textures/gui/melting_pot.png");
    private static final Rectangle HEAT_ICON = new Rectangle(47, 55, 17, 15);
    private static final Rectangle PROGRESS_ARROW = new Rectangle(89, 25, 10, 17);

    public MeltingPotScreen(MeltingPotMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void init() {
        super.init();
        this.addRenderableOnly((Renderable)new FluidStackWidget(this.leftPos + 90, this.topPos - 5, 16, 71, ((MeltingPotMenu)this.menu)::getFluidTank));
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        super.render(gui, mouseX, mouseY, partialTicks);
        this.renderTooltip(gui, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.minecraft == null) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
        guiGraphics.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos - 19, 0, 0, 175, 183);
        int l = ((MeltingPotMenu)this.menu).tileEntity.cookingTime;
        int m = ((MeltingPotMenu)this.menu).tileEntity.cookingProgress;
        guiGraphics.blit(BACKGROUND_TEXTURE, this.leftPos + MeltingPotScreen.PROGRESS_ARROW.x - 25, this.topPos + MeltingPotScreen.PROGRESS_ARROW.y - 2, 176, 15, m != 0 && l != 0 ? m * 24 / l : 1, MeltingPotScreen.PROGRESS_ARROW.height + 7);
        if (((MeltingPotMenu)this.menu).tileEntity.isHeated()) {
            guiGraphics.blit(BACKGROUND_TEXTURE, this.leftPos + MeltingPotScreen.HEAT_ICON.x - 1, this.topPos + MeltingPotScreen.HEAT_ICON.y - 14, 176, 0, MeltingPotScreen.HEAT_ICON.width, MeltingPotScreen.HEAT_ICON.height);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY - 20, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    private void renderHeatIndicatorTooltip(GuiGraphics gui, int mouseX, int mouseY) {
        if (this.isHovering(MeltingPotScreen.HEAT_ICON.x, MeltingPotScreen.HEAT_ICON.y, MeltingPotScreen.HEAT_ICON.width, MeltingPotScreen.HEAT_ICON.height, mouseX, mouseY)) {
            String key = "container.cooking_pot." + (((MeltingPotMenu)this.menu).tileEntity.isHeated() ? "heated" : "not_heated");
            gui.renderTooltip(this.font, (Component)TextUtils.getTranslation((String)key, (Object[])new Object[0]), mouseX, mouseY);
        }
    }
}

