/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.meltingpot;

import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.ExtraDelightConfig;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.util.BottleFluidRegistry;
import com.lance5057.extradelight.workstations.meltingpot.MeltingPotRecipe;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;

public class MeltingPotBlockEntity
extends BlockEntity
implements HeatableBlockEntity {
    public static final String ITEM_TAG = "inv";
    private final ItemStackHandler items = this.createItemHandler();
    private final Lazy<IItemHandlerModifiable> itemHandler = Lazy.of(() -> this.items);
    public static final int INPUT_SLOT = 0;
    public static final int BUCKET_SLOT = 1;
    public static final int BUCKET_SLOT_OUT = 2;
    private final FluidTank fluids = this.createFluidHandler();
    public int cookingTime = 0;
    public int cookingProgress = 0;
    private final RecipeManager.CachedCheck<SingleRecipeInput, MeltingPotRecipe> quickCheck = RecipeManager.createCheck(ExtraDelightRecipes.MELTING_POT.get());

    public FluidTank getFluidTank() {
        return this.fluids;
    }

    public MeltingPotBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ExtraDelightBlockEntities.MELTING_POT.get(), pos, blockState);
    }

    public IItemHandlerModifiable getItemHandler() {
        return (IItemHandlerModifiable)this.itemHandler.get();
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(3){

            public boolean isItemValid(int slot, ItemStack stack) {
                return slot != 2;
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }

            protected void onContentsChanged(int slot) {
                MeltingPotBlockEntity.this.updateInventory();
            }
        };
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T be) {
        MeltingPotBlockEntity pBlockEntity = (MeltingPotBlockEntity)be;
        if (pBlockEntity.isHeated()) {
            RecipeHolder recipeholder;
            IItemHandlerModifiable h = pBlockEntity.getItemHandler();
            FluidTank f = pBlockEntity.getFluidTank();
            ItemStack itemstack = h.getStackInSlot(0);
            if (!itemstack.isEmpty()) {
                recipeholder = pBlockEntity.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(itemstack), level).orElse(null);
                if (recipeholder != null) {
                    pBlockEntity.cookingTime = ((MeltingPotRecipe)recipeholder.value()).cooktime;
                } else {
                    pBlockEntity.cookingTime = 0;
                    pBlockEntity.cookingProgress = 0;
                }
            } else {
                recipeholder = null;
                pBlockEntity.cookingTime = 0;
                pBlockEntity.cookingProgress = 0;
            }
            if (recipeholder != null) {
                FluidStack fluid = ((MeltingPotRecipe)recipeholder.value()).result.copy();
                if ((f.isEmpty() || f.fill(fluid, IFluidHandler.FluidAction.SIMULATE) == fluid.getAmount()) && !itemstack.isEmpty()) {
                    ++pBlockEntity.cookingProgress;
                    if (((Boolean)ExtraDelightConfig.ENABLE_DEBUG_MODE.get()).booleanValue()) {
                        pBlockEntity.cookingProgress += 100;
                    }
                    if (pBlockEntity.cookingProgress >= pBlockEntity.cookingTime) {
                        f.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                        itemstack.shrink(1);
                        pBlockEntity.cookingProgress = 0;
                        if (itemstack.isEmpty()) {
                            pBlockEntity.cookingTime = 0;
                        }
                        level.sendBlockUpdated(pos, state, state, 3);
                    } else {
                        for (int k = 0; k < 1; ++k) {
                            level.addParticle((ParticleOptions)ParticleTypes.DOLPHIN, (double)pos.getX() + level.random.nextDouble() / 16.0, (double)pos.getY() - level.random.nextDouble() / 16.0, (double)pos.getZ() + level.random.nextDouble() / 16.0, 0.0, 1.0, 0.0);
                        }
                    }
                }
            } else {
                pBlockEntity.cookingProgress = 0;
            }
            if (!h.getStackInSlot(1).isEmpty()) {
                ItemStack i;
                ItemStack inputItem = h.getStackInSlot(1);
                ItemStack outputItem = h.getStackInSlot(2);
                if (inputItem.getItem() == Items.BUCKET) {
                    FluidStack stack;
                    if (!f.getFluid().isEmpty() && (stack = f.drain(1000, IFluidHandler.FluidAction.SIMULATE)).getAmount() == 1000 && (outputItem.isEmpty() || outputItem.getItem() == stack.getFluid().getBucket() && outputItem.getCount() < outputItem.getMaxStackSize())) {
                        f.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                        inputItem.shrink(1);
                        if (outputItem.isEmpty()) {
                            h.setStackInSlot(2, stack.getFluid().getBucket().getDefaultInstance());
                        } else {
                            outputItem.grow(1);
                        }
                    }
                } else if (inputItem.getCapability(Capabilities.FluidHandler.ITEM) != null) {
                    IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)inputItem.getCapability(Capabilities.FluidHandler.ITEM);
                    FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandlerItem, (IFluidHandler)f, (int)f.getFluidAmount(), (boolean)true);
                } else if (inputItem.is(Items.GLASS_BOTTLE) && !(i = BottleFluidRegistry.getBottleFromFluid(pBlockEntity.getFluidTank().getFluid())).isEmpty() && pBlockEntity.getFluidTank().drain(250, IFluidHandler.FluidAction.SIMULATE).getAmount() == 250) {
                    pBlockEntity.getFluidTank().drain(250, IFluidHandler.FluidAction.EXECUTE);
                    inputItem.shrink(1);
                    if (pBlockEntity.items.getStackInSlot(2).isEmpty()) {
                        pBlockEntity.items.setStackInSlot(2, i);
                    } else {
                        ItemStack s = pBlockEntity.items.getStackInSlot(2);
                        if (ItemStack.isSameItem((ItemStack)i, (ItemStack)s)) {
                            s.setCount(s.getCount() + i.getCount());
                        }
                    }
                }
            }
        }
        pBlockEntity.updateInventory();
    }

    public boolean isHeated() {
        if (this.level == null) {
            return false;
        }
        return this.isHeated(this.level, this.worldPosition);
    }

    public void updateInventory() {
        this.requestModelDataUpdate();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        this.setChanged();
    }

    private FluidTank createFluidHandler() {
        FluidTank tank = new FluidTank(6000){

            protected void onContentsChanged() {
                MeltingPotBlockEntity.this.requestModelDataUpdate();
                MeltingPotBlockEntity.this.getLevel().sendBlockUpdated(MeltingPotBlockEntity.this.getBlockPos(), MeltingPotBlockEntity.this.getBlockState(), MeltingPotBlockEntity.this.getBlockState(), 3);
                MeltingPotBlockEntity.this.setChanged();
            }
        };
        return tank;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.writeNBT(nbt, registries);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.readNBT(tag, registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        this.readNBT(tag, registries);
    }

    void readNBT(CompoundTag nbt, HolderLookup.Provider registries) {
        this.fluids.readFromNBT(registries, nbt);
        if (nbt.contains(ITEM_TAG)) {
            this.items.deserializeNBT(registries, nbt.getCompound(ITEM_TAG));
        }
        this.cookingTime = nbt.getInt("cooktime");
        this.cookingProgress = nbt.getInt("cookprogress");
    }

    CompoundTag writeNBT(CompoundTag tag, HolderLookup.Provider registries) {
        this.fluids.writeToNBT(registries, tag);
        tag.put(ITEM_TAG, (Tag)this.items.serializeNBT(registries));
        tag.putInt("cooktime", this.cookingTime);
        tag.putInt("cookprogress", this.cookingProgress);
        return tag;
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.readNBT(nbt, registries);
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.writeNBT(nbt, registries);
    }
}

