/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.dryingrack;

import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.util.BlockEntityUtils;
import com.lance5057.extradelight.workstations.BlockEntityItemHandler;
import com.lance5057.extradelight.workstations.dryingrack.DryingRackRecipe;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class DryingRackBlockEntity
extends BlockEntity {
    public static final String ITEM_TAG = "inv";
    private final ItemStackHandler items = this.createHandler();
    private final Lazy<IItemHandlerModifiable> itemHandler = Lazy.of(() -> this.items);
    public static final int NUM_SLOTS = 8;
    private int[] cookingProgress = new int[8];
    private int[] cookingTime = new int[8];
    private ItemStack[] results = new ItemStack[8];

    public DryingRackBlockEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)ExtraDelightBlockEntities.DRYING_RACK.get(), pPos, pState);
        for (int i = 0; i < 8; ++i) {
            this.results[i] = ItemStack.EMPTY;
        }
    }

    private ItemStackHandler createHandler() {
        return new BlockEntityItemHandler<DryingRackBlockEntity>(this, this, 8){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return 1;
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                Optional<RecipeHolder<DryingRackRecipe>> r = ((DryingRackBlockEntity)((Object)this.getBlockEntity())).matchRecipe(stack);
                if (r.isPresent() && this.getStackInSlot(slot) == ItemStack.EMPTY) {
                    ((DryingRackBlockEntity)((Object)this.getBlockEntity())).cookingTime[slot] = ((DryingRackRecipe)r.get().value()).cookingTime;
                    ((DryingRackBlockEntity)((Object)this.getBlockEntity())).cookingProgress[slot] = 0;
                    ((DryingRackBlockEntity)((Object)this.getBlockEntity())).results[slot] = ((DryingRackRecipe)r.get().value()).result;
                    ((DryingRackBlockEntity)((Object)this.getBlockEntity())).updateInventory();
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (!simulate) {
                    ((DryingRackBlockEntity)((Object)this.getBlockEntity())).cookingProgress[slot] = 0;
                    ((DryingRackBlockEntity)((Object)this.getBlockEntity())).cookingTime[slot] = 0;
                }
                return super.extractItem(slot, amount, simulate);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return ((DryingRackBlockEntity)((Object)this.getBlockEntity())).matchRecipe(stack).isPresent();
            }

            protected void onContentsChanged(int slot) {
                ((DryingRackBlockEntity)((Object)this.getBlockEntity())).updateInventory();
            }
        };
    }

    public void insertItem(ItemStack stack) {
        BlockEntityUtils.Inventory.insertItem((IItemHandler)this.items, stack, 8);
        this.updateInventory();
    }

    public void extractItem(Player p) {
        BlockEntityUtils.Inventory.extractItem(p, (IItemHandler)this.items, 8);
        this.updateInventory();
    }

    public IItemHandlerModifiable getItemHandler() {
        return (IItemHandlerModifiable)this.itemHandler.get();
    }

    public void updateInventory() {
        this.requestModelDataUpdate();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        this.setChanged();
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T be) {
        DryingRackBlockEntity pBlockEntity = (DryingRackBlockEntity)be;
        boolean flag = false;
        IItemHandlerModifiable h = pBlockEntity.getItemHandler();
        for (int i = 0; i < 8; ++i) {
            ItemStack itemstack = h.getStackInSlot(i);
            if (itemstack.isEmpty()) continue;
            flag = true;
            int n = i;
            pBlockEntity.cookingProgress[n] = pBlockEntity.cookingProgress[n] + 1;
            if (pBlockEntity.cookingProgress[i] >= pBlockEntity.cookingTime[i]) {
                if (pBlockEntity.results[i].isEmpty()) continue;
                SimpleContainer container = new SimpleContainer(new ItemStack[]{itemstack});
                ItemStack itemstack1 = pBlockEntity.results[i].copy();
                pBlockEntity.results[i] = ItemStack.EMPTY;
                h.setStackInSlot(i, itemstack1);
                level.sendBlockUpdated(pos, state, state, 3);
                continue;
            }
            for (int k = 0; k < 1; ++k) {
                float yOff = (i > 3 ? 0.5f : 0.0f) + 0.5f;
                float xOff = 0.0f;
                float zOff = 0.0f;
                switch (i % 4) {
                    case 0: {
                        xOff = 0.2f + level.random.nextFloat() * 0.2f;
                        zOff = 0.2f + level.random.nextFloat() * 0.2f;
                        break;
                    }
                    case 1: {
                        xOff = 0.2f + level.random.nextFloat() * 0.2f;
                        zOff = 0.8f - level.random.nextFloat() * 0.2f;
                        break;
                    }
                    case 2: {
                        xOff = 0.8f - level.random.nextFloat() * 0.2f;
                        zOff = 0.8f - level.random.nextFloat() * 0.2f;
                        break;
                    }
                    case 3: {
                        xOff = 0.8f - level.random.nextFloat() * 0.2f;
                        zOff = 0.2f + level.random.nextFloat() * 0.2f;
                    }
                }
                level.addParticle((ParticleOptions)ParticleTypes.DOLPHIN, (double)pos.getX() + level.random.nextDouble() / 16.0 + (double)xOff, (double)pos.getY() - level.random.nextDouble() / 16.0 + (double)yOff, (double)pos.getZ() + level.random.nextDouble() / 16.0 + (double)zOff, 0.0, 1.0, 0.0);
            }
        }
        if (flag) {
            DryingRackBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.writeNBT(nbt, registries);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.readNBT(tag, registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        this.readNBT(tag, registries);
    }

    void readNBT(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains(ITEM_TAG)) {
            this.items.deserializeNBT(registries, nbt.getCompound(ITEM_TAG));
        }
        this.cookingProgress = nbt.getIntArray("CookingTimes");
        this.cookingTime = nbt.getIntArray("CookingTotalTimes");
        for (int i = 0; i < 8; ++i) {
            int f = i;
            if (!nbt.contains("item_" + i)) continue;
            ItemStack.parse((HolderLookup.Provider)registries, (Tag)nbt.getCompound("item_" + i)).ifPresent(stack -> {
                this.results[f] = stack;
            });
        }
    }

    CompoundTag writeNBT(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put(ITEM_TAG, (Tag)this.items.serializeNBT(registries));
        tag.putIntArray("CookingTimes", this.cookingProgress);
        tag.putIntArray("CookingTotalTimes", this.cookingTime);
        for (int i = 0; i < 8; ++i) {
            if (this.results[i].isEmpty()) continue;
            tag.put("item_" + i, this.results[i].save(registries));
        }
        return tag;
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.readNBT(nbt, registries);
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.writeNBT(nbt, registries);
    }

    public Optional<RecipeHolder<DryingRackRecipe>> matchRecipe(ItemStack itemstack) {
        if (this.level != null) {
            return this.level.getRecipeManager().getRecipeFor(ExtraDelightRecipes.DRYING_RACK.get(), (RecipeInput)new SingleRecipeInput(itemstack), this.level);
        }
        return Optional.empty();
    }
}

