/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.doughshaping.recipes;

import com.lance5057.extradelight.ExtraDelightBlocks;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DoughShapingRecipe
extends SingleItemRecipe {
    public DoughShapingRecipe(String pGroup, Ingredient pIngredient, ItemStack pResult) {
        super(ExtraDelightRecipes.DOUGH_SHAPING.get(), ExtraDelightRecipes.DOUGH_SHAPING_SERIALIZER.get(), pGroup, pIngredient, pResult);
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return this.ingredient.test(input.item());
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ExtraDelightBlocks.DOUGH_SHAPING.get());
    }

    public String getGroup() {
        return this.group;
    }

    public static class Serializer
    implements RecipeSerializer<DoughShapingRecipe> {
        private static final MapCodec<DoughShapingRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(DoughShapingRecipe::getGroup), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(p_301068_ -> ((DoughShapingRecipe)p_301068_).ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(r -> ((DoughShapingRecipe)r).result)).apply((Applicative)inst, DoughShapingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DoughShapingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static DoughShapingRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
            String s = pBuffer.readUtf();
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)pBuffer);
            return new DoughShapingRecipe(s, ingredient, itemstack);
        }

        public static void toNetwork(RegistryFriendlyByteBuf pBuffer, DoughShapingRecipe pRecipe) {
            pBuffer.writeUtf(pRecipe.group);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.ingredient);
            ItemStack.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.result);
        }

        public MapCodec<DoughShapingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DoughShapingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

