/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.chiller;

import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.ExtraDelightComponents;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.items.components.ChillComponent;
import com.lance5057.extradelight.util.BlockEntityUtils;
import com.lance5057.extradelight.util.BottleFluidRegistry;
import com.lance5057.extradelight.workstations.FancyTank;
import com.lance5057.extradelight.workstations.IFancyTankHandler;
import com.lance5057.extradelight.workstations.chiller.ChillerBlock;
import com.lance5057.extradelight.workstations.chiller.ChillerRecipe;
import com.lance5057.extradelight.workstations.chiller.ChillerRecipeWrapper;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class ChillerBlockEntity
extends BlockEntity
implements IFancyTankHandler<ChillerBlockEntity> {
    public static final int INGREDIENT_SLOTS = 4;
    public static final int CONTAINER_SLOT = 5;
    public static final int OUTPUT_SLOT = 6;
    public static final int FLUID_IN = 7;
    public static final int FLUID_OUT = 8;
    public static final int DRIP_TRAY_OUT = 9;
    public static final int ICE = 10;
    public static final int INVENTORY_SIZE = 11;
    public static final String ITEM_TAG = "inv";
    private final ItemStackHandler inventory = this.createHandler();
    private final Lazy<IItemHandlerModifiable> itemHandler = Lazy.of(() -> this.inventory);
    private int cookTime;
    private int cookTimeTotal;
    private int chilltime;
    private int chillDuration;
    private ResourceLocation lastRecipeID;
    private boolean checkNewRecipe;
    private final RecipeManager.CachedCheck<ChillerRecipeWrapper, ChillerRecipe> quickCheck = RecipeManager.createCheck(ExtraDelightRecipes.CHILLER.get());
    private final FancyTank fluid = this.createFluidHandler();
    private final FluidTank dripTray = this.createDripFluidHandler();

    @Override
    public int getFluidInSlot() {
        return 7;
    }

    @Override
    public int getFluidOutSlot() {
        return 8;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public int getCookTimeTotal() {
        return this.cookTimeTotal;
    }

    public int getChilltime() {
        return this.chilltime;
    }

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return (IItemHandlerModifiable)this.itemHandler.get();
    }

    private FancyTank createFluidHandler() {
        FancyTank tank = new FancyTank(1000, e -> true, 1){

            @Override
            protected void onContentsChanged() {
                super.onContentsChanged();
                Level level = ChillerBlockEntity.this.getLevel();
                if (level == null) {
                    return;
                }
                ChillerBlockEntity.this.requestModelDataUpdate();
                level.sendBlockUpdated(ChillerBlockEntity.this.getBlockPos(), ChillerBlockEntity.this.getBlockState(), ChillerBlockEntity.this.getBlockState(), 3);
                ChillerBlockEntity.this.setChanged();
            }
        };
        return tank;
    }

    private FluidTank createDripFluidHandler() {
        FluidTank tank = new FluidTank(1000){

            protected void onContentsChanged() {
                ChillerBlockEntity.this.requestModelDataUpdate();
                ChillerBlockEntity.this.getLevel().sendBlockUpdated(ChillerBlockEntity.this.getBlockPos(), ChillerBlockEntity.this.getBlockState(), ChillerBlockEntity.this.getBlockState(), 3);
                ChillerBlockEntity.this.setChanged();
            }
        };
        return tank;
    }

    @Override
    public FancyTank getFluidTank() {
        return this.fluid;
    }

    public FluidTank getDripTray() {
        return this.dripTray;
    }

    public ChillerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExtraDelightBlockEntities.CHILLER.get(), pos, state);
    }

    public static void drainDripTray(ChillerBlockEntity bowl) {
        ItemStack inputItem = bowl.inventory.getStackInSlot(9);
        if (!inputItem.isEmpty()) {
            FluidStack stack;
            if (inputItem.getItem() == Items.BUCKET) {
                FluidStack stack2 = bowl.getDripTray().drain(1000, IFluidHandler.FluidAction.SIMULATE);
                if (stack2.getAmount() == 1000) {
                    bowl.getDripTray().drain(1000, IFluidHandler.FluidAction.EXECUTE);
                    inputItem.shrink(1);
                    bowl.inventory.setStackInSlot(9, stack2.getFluid().getBucket().getDefaultInstance());
                }
            } else if (inputItem.getCapability(Capabilities.FluidHandler.ITEM) != null) {
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)inputItem.getCapability(Capabilities.FluidHandler.ITEM);
                int filled = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandlerItem, (IFluidHandler)bowl.getDripTray(), (int)bowl.getDripTray().getFluidAmount(), (boolean)true).getAmount();
                if (filled > 0) {
                    bowl.inventory.setStackInSlot(9, fluidHandlerItem.getContainer());
                }
            } else if (inputItem.getItem() == Items.GLASS_BOTTLE && (stack = bowl.getDripTray().drain(250, IFluidHandler.FluidAction.SIMULATE)).getAmount() == 250) {
                bowl.getDripTray().drain(stack, IFluidHandler.FluidAction.EXECUTE);
                BlockEntityUtils.Inventory.dropItemInWorld(PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER), bowl.level, bowl.getBlockPos());
                inputItem.shrink(1);
            }
        }
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T be) {
        RecipeHolder recipeholder;
        ChillerBlockEntity chiller = (ChillerBlockEntity)be;
        ChillerBlockEntity.drainDripTray(chiller);
        if (chiller.chilltime > 0) {
            --chiller.chilltime;
            chiller.dripTray.fill(new FluidStack((Fluid)Fluids.WATER, 1), IFluidHandler.FluidAction.EXECUTE);
        }
        if ((recipeholder = (RecipeHolder)chiller.quickCheck.getRecipeFor((RecipeInput)new ChillerRecipeWrapper((IItemHandler)chiller.inventory, chiller.fluid.getFluid()), level).orElse(null)) != null) {
            chiller.cookTimeTotal = ((ChillerRecipe)recipeholder.value()).getCookTime();
            if (chiller.cookTime >= chiller.cookTimeTotal) {
                ItemStack result = ((ChillerRecipe)recipeholder.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).copy();
                ItemStack test = chiller.inventory.insertItem(6, result, true);
                if (test.isEmpty()) {
                    ChillerBlockEntity.dropContainers(state, chiller, level);
                    ChillerBlockEntity.subtractItems(chiller, ((ChillerRecipe)recipeholder.value()).shouldConsumeContainer(), result.getCount());
                    chiller.fluid.drain(((ChillerRecipe)recipeholder.value()).getFluid(), IFluidHandler.FluidAction.EXECUTE);
                    chiller.inventory.insertItem(6, result, false);
                    chiller.cookTime = 0;
                }
            } else if (ChillerBlockEntity.isChilling(chiller)) {
                ++chiller.cookTime;
            }
        } else {
            chiller.cookTime = 0;
            chiller.cookTimeTotal = 0;
        }
        chiller.updateInventory();
    }

    private static boolean isChilling(ChillerBlockEntity chiller) {
        if (chiller.dripTray.getFluidAmount() < 1000) {
            if (chiller.chilltime <= 0) {
                ItemStack ice;
                ChillComponent time;
                if (!chiller.inventory.getStackInSlot(10).isEmpty() && (time = (ChillComponent)(ice = chiller.inventory.getStackInSlot(10)).get((DataComponentType)ExtraDelightComponents.CHILL.get())) != null) {
                    chiller.chilltime = time.time();
                    chiller.chillDuration = time.time();
                    ice.shrink(1);
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private static void subtractItems(ChillerBlockEntity chiller, boolean consumeContainer, int k) {
        ItemStackHandler i = chiller.inventory;
        if (consumeContainer) {
            i.getStackInSlot(5).shrink(k);
        }
        for (int j = 0; j < 4; ++j) {
            i.getStackInSlot(j).shrink(1);
        }
    }

    private static void dropContainers(BlockState state, @NotNull ChillerBlockEntity chiller, Level level) {
        Direction direction = ((Direction)state.getValue((Property)ChillerBlock.FACING)).getCounterClockWise();
        double x = (double)chiller.worldPosition.getX() + 0.5 + (double)direction.getStepX() * 0.25;
        double y = (double)chiller.worldPosition.getY() + 0.7;
        double z = (double)chiller.worldPosition.getZ() + 0.5 + (double)direction.getStepZ() * 0.25;
        for (int i = 0; i < 4; ++i) {
            ItemUtils.spawnItemEntity((Level)level, (ItemStack)chiller.inventory.getStackInSlot(i).getCraftingRemainingItem().copy(), (double)x, (double)y, (double)z, (double)((float)direction.getStepX() * 0.08f), (double)0.25, (double)((float)direction.getStepZ() * 0.08f));
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.writeNBT(nbt, registries);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.readNBT(tag, registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        this.readNBT(tag, registries);
    }

    void readNBT(CompoundTag nbt, HolderLookup.Provider registries) {
        this.fluid.readFromNBT(registries, nbt.getCompound("tank"));
        this.dripTray.readFromNBT(registries, nbt.getCompound("driptray"));
        if (nbt.contains(ITEM_TAG)) {
            this.inventory.deserializeNBT(registries, nbt.getCompound(ITEM_TAG));
        }
        this.cookTime = nbt.getInt("cooktime");
        this.cookTimeTotal = nbt.getInt("cookprogress");
        this.chillDuration = nbt.getInt("chillduration");
        this.chilltime = nbt.getInt("chilltime");
    }

    CompoundTag writeNBT(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("tank", (Tag)this.fluid.writeToNBT(registries, new CompoundTag()));
        tag.put("driptray", (Tag)this.dripTray.writeToNBT(registries, new CompoundTag()));
        tag.put(ITEM_TAG, (Tag)this.inventory.serializeNBT(registries));
        tag.putInt("cooktime", this.cookTime);
        tag.putInt("cookprogress", this.cookTimeTotal);
        tag.putInt("chillduration", this.chillDuration);
        tag.putInt("chilltime", this.chilltime);
        return tag;
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.readNBT(nbt, registries);
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.writeNBT(nbt, registries);
    }

    private Optional<RecipeHolder<ChillerRecipe>> getMatchingRecipe(ChillerRecipeWrapper inventoryWrapper) {
        if (this.level == null) {
            return Optional.empty();
        }
        return this.quickCheck.getRecipeFor((RecipeInput)inventoryWrapper, this.level);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(11){

            protected void onContentsChanged(int slot) {
                ChillerBlockEntity.this.updateInventory();
                if (slot == 7) {
                    ChillerBlockEntity.this.fillInternal(ChillerBlockEntity.this);
                }
                if (slot == 8) {
                    ChillerBlockEntity.this.drainInternal(ChillerBlockEntity.this);
                }
                if (slot == 9) {
                    ChillerBlockEntity.drainDripTray(ChillerBlockEntity.this);
                }
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                switch (slot) {
                    case 7: {
                        return stack.getCapability(Capabilities.FluidHandler.ITEM) != null || stack.is(Items.BUCKET) || !BottleFluidRegistry.getFluidFromBottle(stack).isEmpty();
                    }
                    case 8: {
                        return stack.getCapability(Capabilities.FluidHandler.ITEM) != null || stack.is(Items.BUCKET) || ItemStack.isSameItem((ItemStack)stack, (ItemStack)BottleFluidRegistry.getBottleFromFluid(ChillerBlockEntity.this.getFluidTank().drain(250, IFluidHandler.FluidAction.SIMULATE)).getCraftingRemainingItem()) || stack.is(Items.GLASS_BOTTLE);
                    }
                    case 10: {
                        return stack.has((DataComponentType)ExtraDelightComponents.CHILL.get());
                    }
                }
                return true;
            }
        };
    }

    @Override
    public void updateInventory() {
        this.requestModelDataUpdate();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        this.setChanged();
    }

    public int getChillDuration() {
        return this.chillDuration;
    }
}

