/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations;

import com.lance5057.extradelight.fluids.FluidKey;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class FancyTank
implements IFluidHandler,
IFluidTank {
    protected Predicate<FluidStack> validator;
    protected LinkedHashMap<FluidKey, Integer> fluid;
    protected int capacity;
    protected final int variety_cap;
    private boolean full;
    private boolean slots_full;

    public int getVarietyCap() {
        return this.variety_cap;
    }

    public FancyTank(int capacity) {
        this(capacity, e -> true, 6);
    }

    public FancyTank(int capacity, Predicate<FluidStack> validator) {
        this(capacity, validator, 6);
    }

    public FancyTank(int capacity, Predicate<FluidStack> validator, int variety_cap) {
        this.capacity = capacity;
        this.validator = validator;
        this.fluid = new LinkedHashMap();
        this.full = false;
        this.variety_cap = variety_cap;
        this.slots_full = false;
    }

    public int getTotalAmount() {
        return this.fluid.values().stream().mapToInt(i -> i).sum();
    }

    public FancyTank setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public FancyTank setValidator(Predicate<FluidStack> validator) {
        if (validator != null) {
            this.validator = validator;
        }
        return this;
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.validator.test(stack);
    }

    public int getCapacity(int tank) {
        return this.capacity / this.variety_cap;
    }

    public FluidStack getFluid(int tank) {
        Iterator<Map.Entry<FluidKey, Integer>> itr = this.fluid.entrySet().iterator();
        while (tank-- > 0 && itr.hasNext()) {
            itr.next();
        }
        if (!itr.hasNext()) {
            return FluidStack.EMPTY;
        }
        Map.Entry<FluidKey, Integer> tmp = itr.next();
        FluidStack target = tmp.getKey().createStack(tmp.getValue());
        return target;
    }

    public int getFluidAmount(int tank) {
        FluidStack target = this.getFluid(tank);
        return target.getAmount();
    }

    public synchronized FancyTank readFromNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
        this.fluid.clear();
        this.slots_full = false;
        int i = 0;
        while (nbt.contains("Fluid" + i)) {
            FluidStack dat = FluidStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Fluid" + i));
            if (!dat.isEmpty()) {
                this.fill(dat, IFluidHandler.FluidAction.EXECUTE);
            }
            ++i;
        }
        return this;
    }

    public synchronized CompoundTag writeToNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
        int index = 0;
        for (Map.Entry<FluidKey, Integer> entry : this.fluid.entrySet()) {
            FluidStack stack;
            if (entry.getValue() <= 0 || (stack = entry.getKey().createStack(entry.getValue())).isEmpty()) continue;
            nbt.put("Fluid" + index, stack.save(lookupProvider));
            ++index;
        }
        return nbt;
    }

    public int getTanks() {
        return this.fluid.size();
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluid(tank);
    }

    public int getTankCapacity(int tank) {
        return this.capacity;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int fill = this.doFill(resource, action);
        return fill;
    }

    public int getVacancy() {
        return this.capacity - this.getTotalAmount();
    }

    private synchronized int doFill(FluidStack resource, IFluidHandler.FluidAction action) {
        boolean applyChanges;
        FluidKey key;
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        if (this.slots_full && !this.fluid.containsKey(key = new FluidKey(resource))) {
            return 0;
        }
        if (this.full) {
            return 0;
        }
        int vacancy = this.capacity - this.getTotalAmount();
        int fillTotal = resource.getAmount();
        boolean bl = applyChanges = !action.simulate();
        if (vacancy < fillTotal) {
            if (applyChanges && vacancy == 0) {
                this.full = true;
            }
            return 0;
        }
        FluidKey key2 = new FluidKey(resource);
        if (fillTotal <= 0) {
            return 0;
        }
        if (applyChanges) {
            this.fluid.merge(key2, resource.getAmount(), Integer::sum);
            this.onContentsChanged();
        }
        return fillTotal;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.doDrain(resource, action);
    }

    public FluidStack drain(SizedFluidIngredient resource, IFluidHandler.FluidAction action) {
        FluidStack tmp = resource.getFluids()[0];
        return this.doDrain(tmp, action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (Map.Entry<FluidKey, Integer> i : this.fluid.entrySet()) {
            FluidStack s = this.doDrain(i.getKey().createStack(maxDrain), action);
            if (s.isEmpty()) continue;
            return s;
        }
        return FluidStack.EMPTY;
    }

    private FluidStack doDrain(FluidStack drain, IFluidHandler.FluidAction action) {
        return this.doDrain(drain, action, false);
    }

    private synchronized FluidStack doDrain(FluidStack drain, IFluidHandler.FluidAction action, boolean iff) {
        int maxDrain = drain.getAmount();
        if (maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        FluidKey key = new FluidKey(drain);
        int keyval = this.fluid.getOrDefault(key, -1);
        if (keyval == -1) {
            return FluidStack.EMPTY;
        }
        if (iff && maxDrain > keyval) {
            return FluidStack.EMPTY;
        }
        boolean applyChanges = !action.simulate();
        int maxDrainSanitized = Math.min(maxDrain, keyval);
        FluidStack stack = drain.copyWithAmount(maxDrainSanitized);
        if (applyChanges) {
            this.fluid.merge(key, 0 - maxDrainSanitized, Integer::sum);
            if (this.fluid.getOrDefault(key, -1) <= 0) {
                this.fluid.remove(key);
            }
            if (this.full) {
                this.full = false;
            }
            this.onContentsChanged();
        }
        return stack;
    }

    protected void onContentsChanged() {
        int variety = this.fluid.size();
        this.slots_full = variety >= this.variety_cap;
    }

    public FluidStack getFluid() {
        Map.Entry f = this.fluid.lastEntry();
        if (f != null) {
            return ((FluidKey)f.getKey()).createStack((Integer)f.getValue());
        }
        return FluidStack.EMPTY;
    }

    public int getFluidAmount() {
        return 1000;
    }

    public int getCapacity() {
        return 0;
    }

    public boolean isEmpty(int tank) {
        return this.getFluidAmount(tank) == 0;
    }

    public int getSpace(int tank) {
        return Math.max(0, this.capacity - this.getFluidAmount(tank));
    }

    public List<FluidStack> getAsList() {
        ArrayList<FluidStack> l = new ArrayList<FluidStack>();
        for (int i = 0; i < this.getTanks(); ++i) {
            l.add(this.getFluid(i));
        }
        return l;
    }
}

