/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.util;

import com.lance5057.extradelight.ExtraDelight;
import java.util.Arrays;
import java.util.Random;

public class EllersGen {
    static final char MAZE_WALL = '#';
    static final char MAZE_PATH = ' ';
    static final int UNDETERMINED = -2;
    static final int SET_WALL = -1;
    int rows;
    int cols;
    int act_rows;
    int act_cols;
    char[][] field;
    int[] current;
    int[] next;
    int numSet;

    public EllersGen(int nRows, int nCols) {
        int i;
        this.act_rows = nRows;
        this.act_cols = nCols;
        this.rows = this.act_rows * 2 + 1;
        this.cols = this.act_cols * 2 + 1;
        this.field = new char[this.rows][this.cols];
        this.current = new int[this.act_cols * 2 - 1];
        this.next = new int[this.act_cols * 2 - 1];
        for (i = 0; i < this.field[0].length; ++i) {
            for (int j = 0; j < this.field.length; ++j) {
                this.field[i][j] = 35;
            }
        }
        for (i = 0; i < this.next.length; ++i) {
            this.next[i] = -2;
        }
        for (i = 0; i < this.current.length; i += 2) {
            this.current[i] = i / 2 + 1;
            if (i == this.current.length - 1) continue;
            this.current[i + 1] = -1;
        }
        this.numSet = this.current[this.current.length - 1];
    }

    public void makeMaze() {
        Random rand = new Random();
        for (int q = 0; q < this.act_rows - 1; ++q) {
            if (q != 0) {
                for (int i = 0; i < this.current.length; ++i) {
                    this.current[i] = this.next[i];
                    this.next[i] = -2;
                }
            }
            this.joinSets();
            this.makeVerticalCuts();
            for (int j = 0; j < this.current.length; j += 2) {
                if (this.next[j] == -2) {
                    this.next[j] = ++this.numSet;
                }
                if (j == this.current.length - 1) continue;
                this.next[j + 1] = -1;
            }
            for (int k = 0; k < this.current.length; ++k) {
                if (this.current[k] == -1) {
                    this.field[2 * q + 1][k + 1] = 35;
                    this.field[2 * q + 2][k + 1] = 35;
                    continue;
                }
                this.field[2 * q + 1][k + 1] = 32;
                if (this.current[k] != this.next[k]) continue;
                this.field[2 * q + 2][k + 1] = 32;
            }
        }
        this.makeLastRow();
        this.makeOpenings();
    }

    private void joinSets() {
        Random rand = new Random();
        for (int i = 1; i < this.current.length - 1; i += 2) {
            if (this.current[i] != -1 || this.current[i - 1] == this.current[i + 1] || !rand.nextBoolean()) continue;
            this.current[i] = 0;
            int old = Math.max(this.current[i - 1], this.current[i + 1]);
            int next = Math.min(this.current[i - 1], this.current[i + 1]);
            for (int j = 0; j < this.current.length; ++j) {
                if (this.current[j] != old) continue;
                this.current[j] = next;
            }
        }
    }

    private void makeVerticalCuts() {
        int end;
        Random rand = new Random();
        int begining = 0;
        do {
            int i;
            for (i = begining; i < this.current.length - 1 && this.current[i] == this.current[i + 2]; i += 2) {
            }
            end = i;
            boolean madeVertical = false;
            do {
                for (int j = begining; j <= end; j += 2) {
                    if (!rand.nextBoolean()) continue;
                    this.next[j] = this.current[j];
                    madeVertical = true;
                }
            } while (!madeVertical);
            begining = end + 2;
        } while (end != this.current.length - 1);
    }

    private void makeLastRow() {
        int i;
        for (i = 0; i < this.current.length; ++i) {
            this.current[i] = this.next[i];
        }
        for (i = 1; i < this.current.length - 1; i += 2) {
            if (this.current[i] != -1 || this.current[i - 1] == this.current[i + 1]) continue;
            this.current[i] = 0;
            int old = Math.max(this.current[i - 1], this.current[i + 1]);
            int next = Math.min(this.current[i - 1], this.current[i + 1]);
            for (int j = 0; j < this.current.length; ++j) {
                if (this.current[j] != old) continue;
                this.current[j] = next;
            }
        }
        for (int k = 0; k < this.current.length; ++k) {
            this.field[this.rows - 2][k + 1] = this.current[k] == -1 ? 35 : 32;
        }
    }

    public void makeOpenings() {
        Random rand = new Random();
        Random rand2 = new Random();
        int entrance_row = rand.nextInt(this.act_rows - 1) * 2 + 1;
        int exit_row = rand2.nextInt(this.act_rows - 1) * 2 + 1;
        this.field[4][0] = 32;
        this.field[4][this.cols - 1] = 32;
        this.field[0][4] = 32;
        this.field[this.rows - 1][4] = 32;
    }

    public void printMaze() {
        for (int i = 0; i < this.rows; ++i) {
            ExtraDelight.logger.debug(Arrays.toString(this.field[i]));
        }
    }

    public char[][] getMaze() {
        return this.field;
    }
}

