/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.util;

import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.ExtraDelightNeoForgeClientEvents;
import com.lance5057.extradelight.data.advancement.EDAdvancementGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredItem;

public class EDItemGenerator {
    public static List<Drink> drinks = new ArrayList<Drink>();
    public static List<DeferredItem<Item>> hotFood = new ArrayList<DeferredItem<Item>>();
    public static List<DeferredItem<Item>> coldFood = new ArrayList<DeferredItem<Item>>();
    DeferredItem<Item> item;

    private EDItemGenerator(DeferredItem<Item> item) {
        this.item = item;
    }

    public static <I extends Item> EDItemGenerator register(String registrationName, Supplier<? extends I> item) {
        return new EDItemGenerator((DeferredItem<Item>)ExtraDelightItems.ITEMS.register(registrationName, item));
    }

    public EDItemGenerator advancementSnack() {
        EDAdvancementGenerator.SNACKS.put(this.item.getRegisteredName(), this.item);
        return this;
    }

    public EDItemGenerator advancementFeast() {
        EDAdvancementGenerator.FEASTS.put(this.item.getRegisteredName(), this.item);
        return this;
    }

    public EDItemGenerator advancementMeal() {
        EDAdvancementGenerator.MEALS.put(this.item.getRegisteredName(), this.item);
        return this;
    }

    public EDItemGenerator advancementDessert() {
        EDAdvancementGenerator.DESSERTS.put(this.item.getRegisteredName(), this.item);
        return this;
    }

    public EDItemGenerator advancementCandy() {
        EDAdvancementGenerator.CANDY.put(this.item.getRegisteredName(), this.item);
        return this;
    }

    public EDItemGenerator advancementCookie() {
        EDAdvancementGenerator.COOKIES.put(this.item.getRegisteredName(), this.item);
        return this;
    }

    public EDItemGenerator advancementButchercraft() {
        EDAdvancementGenerator.BUTCHERCRAFT.put(this.item.getRegisteredName(), this.item);
        return this;
    }

    public EDItemGenerator advancementIngredients() {
        EDAdvancementGenerator.INGREDIENTS.put(this.item.getRegisteredName(), this.item);
        return this;
    }

    public EDItemGenerator butchercraftToolTip() {
        ExtraDelightNeoForgeClientEvents.butchercraft.add(this.item);
        return this;
    }

    public EDItemGenerator feastToolTip() {
        ExtraDelightNeoForgeClientEvents.feasts.add(this.item);
        return this;
    }

    public EDItemGenerator servingToolTip() {
        ExtraDelightNeoForgeClientEvents.servings.add(this.item);
        return this;
    }

    public EDItemGenerator isHotFood() {
        hotFood.add(this.item);
        return this;
    }

    public EDItemGenerator isColdFood() {
        coldFood.add(this.item);
        return this;
    }

    public DeferredItem<Item> finish() {
        return this.item;
    }

    public Drink drink() {
        EDAdvancementGenerator.DRINKS.put(this.item.getRegisteredName(), this.item);
        return new Drink(this, this.item);
    }

    public class Drink {
        public DeferredItem<Item> item;
        public int thirst;
        public int hydration;
        public int poison;
        public boolean isHot;
        public boolean isCold;

        public Drink(EDItemGenerator this$0, DeferredItem<Item> item2) {
            this.item = item2;
        }

        public Drink setThirst(int t) {
            this.thirst = t;
            return this;
        }

        public Drink setHydration(int h) {
            this.hydration = h;
            return this;
        }

        public Drink setPoison(int p) {
            this.poison = p;
            return this;
        }

        public Drink isHot(boolean hot) {
            this.isHot = hot;
            return this;
        }

        public Drink isCold(boolean cold) {
            this.isCold = cold;
            return this;
        }

        public DeferredItem<Item> finish() {
            drinks.add(this);
            return this.item;
        }
    }
}

