/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.util;

import com.lance5057.extradelight.ExtraDelightComponents;
import com.lance5057.extradelight.ExtraDelightFluids;
import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.data.recipebuilders.BottleFluidRegistryRecipeBuilder;
import com.lance5057.extradelight.items.dynamicfood.api.DynamicItemComponent;
import com.lance5057.extradelight.modules.Fermentation;
import com.lance5057.extradelight.modules.SummerCitrus;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import vectorwing.farmersdelight.common.registry.ModItems;

public class BottleFluidRegistry {
    private static int bottleMB = 250;
    public static List<BottleFluid> registry = new ArrayList<BottleFluid>();

    public static void register(Ingredient bottle, SizedFluidIngredient fluid) {
        registry.add(new BottleFluid(bottle, fluid));
    }

    public static ItemStack getBottleFromFluid(FluidStack f) {
        Optional<BottleFluid> b;
        if (f.getAmount() >= bottleMB && (b = registry.stream().filter(bf -> bf.fluid.test(f)).findFirst()).isPresent()) {
            return b.get().bottle.getItems()[0].copy();
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getBottleFromFluidWithoutSize(Fluid f) {
        Optional<BottleFluid> b = registry.stream().filter(bf -> bf.fluid.test(new FluidStack(f, 1000))).findFirst();
        if (b.isPresent()) {
            return b.get().bottle.getItems()[0].copy();
        }
        return ItemStack.EMPTY;
    }

    public static FluidStack getFluidFromBottle(ItemStack i) {
        Optional<BottleFluid> b = registry.stream().filter(bf -> bf.bottle.test(i)).findFirst();
        if (b.isPresent()) {
            return b.get().fluid.getFluids()[0];
        }
        return FluidStack.EMPTY;
    }

    public static void createRecipesForJEI(RecipeOutput consumer) {
        registry.forEach(bf -> new BottleFluidRegistryRecipeBuilder(bf.bottle, bf.fluid).save(consumer, bf.fluid.getFluids()[0].getDescriptionId()));
    }

    static {
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.APPLE_CIDER.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.APPLE_CIDER.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BBQ_SAUCE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.BBQ.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_SYRUP_BOTTLE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.BLOOD_CHOCOLATE_SYRUP.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BONE_BROTH.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.BROTH.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CACTUS_JUICE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.CACTUS_JUICE.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CARAMEL_SAUCE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.CARAMEL_SAUCE.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COCOA_BUTTER_BOTTLE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.COCOA_BUTTER.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COFFEE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.COFFEE.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COOKING_OIL.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.OIL.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DARK_CHOCOLATE_SYRUP_BOTTLE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.DARK_CHOCOLATE_SYRUP.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.EGG_MIX.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.EGG_MIX.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SummerCitrus.EGG_WHITE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.EGG_WHITE.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GLOW_BERRY_JUICE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.GLOW_BERRY_JUICE.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SummerCitrus.GRAPEFRUIT_JUICE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.GRAPEFRUIT_JUICE.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GRAVY.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.GRAVY.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.HAZELNUT_SPREAD_BOTTLE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.COCOA_NUT_BUTTER_SPREAD.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.HOT_COCOA.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.HOT_COCOA.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(DataComponentIngredient.of((boolean)false, ExtraDelightComponents.DYNAMIC_FOOD, (Object)new DynamicItemComponent(List.of("sweet_berries")), (ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DYNAMIC_JAM.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.JAM.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.KETCHUP.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.KETCHUP.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SummerCitrus.LEMON_JUICE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.LEMON_JUICE.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SummerCitrus.LIME_JUICE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.LIME_JUICE.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MARSHMALLOW_FLUFF_BOTTLE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.MARSHMALLOW_FLUFF.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MAYO.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.MAYO.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.MELON_JUICE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.MELON_JUICE.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.MILK_BOTTLE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)NeoForgeMod.MILK.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MILK_CHOCOLATE_SYRUP_BOTTLE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.MILK_CHOCOLATE_SYRUP.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MILKSHAKE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.MILKSHAKE.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SummerCitrus.ORANGE_JUICE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.ORANGE_JUICE.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.PEANUT_BUTTER_BOTTLE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.NUT_BUTTER.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.SWEET_BERRY_JUICE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.SWEET_BERRY_JUICE.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.TEA.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.TEA.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.TOMATO_JUICE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.TOMATO_JUICE.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.VINEGAR.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.VINEGAR.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.WHIPPED_CREAM.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.WHIPPED_CREAM.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_SYRUP_BOTTLE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.WHITE_CHOCOLATE_SYRUP.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Fermentation.PICKLE_JUICE.get()}), SizedFluidIngredient.of((Fluid)((Fluid)ExtraDelightFluids.PICKLE_JUICE.FLUID.get()), (int)bottleMB));
        BottleFluidRegistry.register(Ingredient.of((ItemStack[])new ItemStack[]{PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER)}), SizedFluidIngredient.of((Fluid)Fluids.WATER, (int)bottleMB));
    }

    public static class BottleFluid {
        public Ingredient bottle;
        public SizedFluidIngredient fluid;

        public BottleFluid(Ingredient b, SizedFluidIngredient f) {
            this.bottle = b;
            this.fluid = f;
        }
    }
}

