/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.recipe;

import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class ShapedWithJarRecipe
extends ShapedRecipe {
    private final List<FluidStack> fluids;

    public ShapedWithJarRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, List<FluidStack> fluid, ItemStack result) {
        super(group, category, pattern, result, true);
        this.fluids = fluid;
    }

    public ShapedWithJarRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, List<FluidStack> fluid, ItemStack result, boolean showNotification) {
        super(group, category, pattern, result, showNotification);
        this.fluids = fluid;
    }

    public boolean matches(CraftingInput input, Level level) {
        if (!this.pattern.matches(input)) {
            return false;
        }
        List<ItemStack> jars = this.gatherJars(input);
        if (jars.size() != this.fluids.size()) {
            return false;
        }
        return this.testJars(jars);
    }

    private List<ItemStack> gatherJars(CraftingInput input) {
        return input.items().stream().filter(j -> j.is((Item)ExtraDelightItems.JAR.get())).toList();
    }

    private boolean testJars(List<ItemStack> jars) {
        List<FluidStack> jarFluids = jars.stream().map(j -> ((IFluidHandlerItem)j.getCapability(Capabilities.FluidHandler.ITEM)).getFluidInTank(0)).toList();
        for (int i = 0; i < this.fluids.size(); ++i) {
            if (this.compareFluid(jarFluids, i)) continue;
            return false;
        }
        return true;
    }

    private boolean compareFluid(List<FluidStack> jarFluids, int i) {
        return jarFluids.stream().anyMatch(j -> j.containsFluid(this.fluids.get(i)));
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        List<ItemStack> jars = this.gatherJars(input);
        for (FluidStack f : this.fluids) {
            ItemStack i = jars.stream().filter(j -> ((IFluidHandlerItem)j.getCapability(Capabilities.FluidHandler.ITEM)).getFluidInTank(0).containsFluid(f)).findFirst().get();
            ((IFluidHandlerItem)i.getCapability(Capabilities.FluidHandler.ITEM)).drain(f, IFluidHandler.FluidAction.EXECUTE);
        }
        return this.getResultItem(registries).copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return ExtraDelightRecipes.SHAPED_JAR_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<ShapedWithJarRecipe> {
        public static final MapCodec<ShapedWithJarRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_311729_ -> p_311729_.getGroup()), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_311732_ -> p_311732_.category()), (App)ShapedRecipePattern.MAP_CODEC.forGetter(p_311733_ -> p_311733_.pattern), (App)FluidStack.OPTIONAL_CODEC.listOf().fieldOf("fluids").forGetter(recipe -> recipe.fluids), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_311730_ -> p_311730_.getResultItem(null)), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(p_311731_ -> p_311731_.showNotification())).apply((Applicative)instance, ShapedWithJarRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedWithJarRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ShapedWithJarRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapedWithJarRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapedWithJarRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)RecipeSerializer.SHAPED_RECIPE.streamCodec().decode((Object)buffer);
            int f = buffer.readVarInt();
            ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
            for (int i = 0; i < f; ++i) {
                FluidStack op = (FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
                if (op == null) continue;
                fluids.add(op);
            }
            return new ShapedWithJarRecipe(shapedRecipe.getGroup(), shapedRecipe.category(), shapedRecipe.pattern, fluids, shapedRecipe.getResultItem(null), shapedRecipe.showNotification());
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, ShapedWithJarRecipe recipe) {
            RecipeSerializer.SHAPED_RECIPE.streamCodec().encode((Object)buffer, (Object)recipe);
            buffer.writeVarInt(recipe.fluids.size());
            for (int i = 0; i < recipe.fluids.size(); ++i) {
                FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.fluids.get(i));
            }
        }
    }
}

