/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.items;

import com.lance5057.extradelight.util.ItemUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class ShuckableCorn
extends Item {
    private final ResourceKey<LootTable> table;

    public ShuckableCorn(ResourceKey<LootTable> t, Item.Properties pProperties) {
        super(pProperties);
        this.table = t;
    }

    public ResourceKey<LootTable> getNextItem() {
        return this.table;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 16;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pUsedHand);
        pPlayer.startUsingItem(pUsedHand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        if (pLivingEntity instanceof Player) {
            int i;
            Player p = (Player)pLivingEntity;
            int c = Math.min(pStack.getCount(), 8);
            for (i = 0; i < 5; ++i) {
                Vec3 vec3 = new Vec3(((double)pLevel.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                vec3 = vec3.xRot(-pLivingEntity.getXRot() * ((float)Math.PI / 180));
                vec3 = vec3.yRot(-pLivingEntity.getYRot() * ((float)Math.PI / 180));
                double d0 = (double)(-pLevel.random.nextFloat()) * 0.6 - 0.3;
                Vec3 vec31 = new Vec3(((double)pLevel.random.nextFloat() - 0.5) * 0.3, d0, 0.6);
                vec31 = vec31.xRot(-pLivingEntity.getXRot() * ((float)Math.PI / 180));
                vec31 = vec31.yRot(-pLivingEntity.getYRot() * ((float)Math.PI / 180));
                vec31 = vec31.add(pLivingEntity.getX(), pLivingEntity.getEyeY(), pLivingEntity.getZ());
                if (pLevel instanceof ServerLevel) {
                    ((ServerLevel)pLevel).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, pStack), vec31.x, vec31.y, vec31.z, 1, vec3.x, vec3.y + 0.05, vec3.z, 0.0);
                    continue;
                }
                pLevel.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, pStack), vec31.x, vec31.y, vec31.z, vec3.x, vec3.y + 0.05, vec3.z);
            }
            for (i = 0; i < c; ++i) {
                if (pLevel == null || pLevel.isClientSide()) continue;
                LootParams pContext = new LootParams.Builder((ServerLevel)pLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)p).create(LootContextParamSets.EMPTY);
                p.getServer().reloadableRegistries().getLootTable(this.table).getRandomItems(pContext).forEach(itemStack -> ItemUtils.giveOrDrop(itemStack, p));
            }
            pStack.shrink(8);
        }
        return pStack;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            MutableComponent textEmpty = TextUtils.getTranslation((String)("tooltip." + BuiltInRegistries.ITEM.getKey((Object)this).getPath()), (Object[])new Object[0]);
            tooltip.add((Component)textEmpty.withStyle(ChatFormatting.GREEN));
        }
    }
}

