/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.items;

import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.recipe.SimpleRecipeWrapper;
import com.lance5057.extradelight.recipe.ToolOnBlockRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class FrostingItem
extends Item {
    public FrostingItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        BlockState bs = pContext.getLevel().getBlockState(pContext.getClickedPos());
        this.convert(pContext.getLevel(), pContext.getClickedPos(), bs, pContext.getPlayer(), pContext.getHand());
        return InteractionResult.PASS;
    }

    protected InteractionResult convert(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        Optional r = level.getRecipeManager().getRecipeFor(ExtraDelightRecipes.TOOL_ON_BLOCK.get(), (RecipeInput)new SimpleRecipeWrapper(heldStack, new ItemStack((ItemLike)state.getBlock().asItem())), level);
        if (r.isPresent()) {
            Block result = ((ToolOnBlockRecipe)((RecipeHolder)r.get()).value()).getResultBlock();
            level.setBlock(pos, result.defaultBlockState(), 3);
            if (!player.getAbilities().instabuild) {
                if (heldStack.isDamageableItem()) {
                    heldStack.hurtAndBreak(1, (LivingEntity)player, null);
                } else {
                    heldStack.shrink(1);
                }
            }
            for (int i = 0; i < 10; ++i) {
                level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, result.defaultBlockState()), (double)((float)pos.getX() + level.random.nextFloat()), (double)((float)pos.getY() + level.random.nextFloat()), (double)((float)pos.getZ() + level.random.nextFloat()), 0.0, 0.0, 0.0);
            }
            level.playSound(null, pos, SoundEvents.SLIME_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip::add, (float)1.0f, (float)context.tickRate());
    }
}

