/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.integration.jei.categories;

import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.util.BottleFluidRegistry;
import com.lance5057.extradelight.workstations.meltingpot.MeltingPotRecipe;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MeltingPotRecipeCategory
implements IRecipeCategory<MeltingPotRecipe> {
    public static final RecipeType<MeltingPotRecipe> TYPE = RecipeType.create((String)"extradelight", (String)"meltingpot", MeltingPotRecipe.class);
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable icon;

    public MeltingPotRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"textures/gui/jei.png"), 203, 107, 53, 47);
        this.localizedName = Component.translatable((String)"extradelight.jei.meltingpot");
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ExtraDelightItems.MELTING_POT.get()));
    }

    public RecipeType<MeltingPotRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MeltingPotRecipe recipe, IFocusGroup focuses) {
        Ingredient input = recipe.input;
        builder.addSlot(RecipeIngredientRole.INPUT, 7, 7).addIngredients(input);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, this.getWidth() / 2 + 4, 7).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, List.of(recipe.result))).setFluidRenderer((long)recipe.result.getAmount(), false, 16, 16);
        IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.CATALYST, this.getWidth() / 2 + 4, 30);
        slot.addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{BottleFluidRegistry.getBottleFromFluidWithoutSize(recipe.result.getFluid()), new ItemStack((ItemLike)recipe.result.getFluid().getBucket())}));
    }
}

